package adt;
import robocode.*;
import java.awt.Color;
import java.util.HashMap;
import java.util.LinkedList;
import java.awt.geom.Point2D;

public class RobotTracker {
	HashMap bots = new HashMap();
	Robot self;

	public RobotTracker( Robot self )
	{
		this.self = self;
	}
		
	public void updateBot( ScannedRobotEvent e )
	{
		RobotMemory other=null;
		double enemyHeading = (self.getHeading() + e.getBearing()+360.0) % 360.0 ;
		double enemyX = self.getX() + e.getDistance()*Math.sin( Math.PI*enemyHeading/180.0 );
		double enemyY = self.getY() + e.getDistance()*Math.cos( Math.PI*enemyHeading/180.0 );
		Point2D.Double posn = new Point2D.Double( enemyX,enemyY );
		
		if ( bots.containsKey( e.getName() ) )
		{
			other = (RobotMemory)bots.get( e.getName() );
		}
		else
		{
			other = addNewRobot( self, e.getName() );
			bots.put( e.getName(), other );						
		}
		other.update( self.getTime(), e, posn );
	}
	
	protected RobotMemory addNewRobot( Robot self, String name )
	{
			System.out.println( "New Robot: "+name );
			return new RobotMemory( self, name );
	}
		
	public Point2D.Double getAimPoint(String name)
	{
		RobotMemory other=null;
		other = (RobotMemory)bots.get( name );
		if ( other != null )
		{
			return other.getAimPoint();
		}
		return null;		
	}

	public double getEnergy(String name)
	{
		RobotMemory other=null;
		other = (RobotMemory)bots.get( name );
		if ( other != null )
		{
			return other.getEnergy();
		}
		return 0.0;		
	}					
}

