package theo.simple.surf.predictor;  
import robocode.*;
import robocode.util.Utils;
import java.util.*;
import java.awt.geom.*;
import java.util.*;
import theo.simple.gun.*;
import theo.simple.Lucid;
import theo.simple.enemy.*;
import theo.simple.wave.*;
import theo.simple.utils.*;
import theo.simple.surf.*;
import java.awt.Color;
import java.awt.Graphics2D;


public class RoboPredicter
{

	//To watch the velocity of a robot

	double totalDistance;
	double turnSegment;
	Point2D.Double nextPosition;
	double moveDistance;
	double heading;
	int veldir;
	
	List<Point2D.Double> positionList = new ArrayList<Point2D.Double>();
	
	

	public RoboPredicter(Object owner, double totalDistance, double heading, int veldir){
		this.totalDistance = totalDistance;
		this.heading = heading;
		this.veldir = veldir;
		this.positionList.clear();
		try{
			LucidSurf moments = (LucidSurf)owner;
			this.nextPosition = new Point2D.Double(moments.pos.x,moments.pos.y);
			developSurf(moments);
		}
		catch(Exception e){
			try{
				LucidGun moments = (LucidGun)owner;
				//this.nextPosition = new Point2D.Double(moments.owner.ourPos.x,moments.owner.ourPos.y);
				//developEnemy(moments);
			}
			catch(Exception ea){
				
			}
		}
	}
	
	protected void developSurf(LucidSurf moments){
		double avengeVelocity =  moments.velocity;
		double distRemaining = this.totalDistance;
		Moments skidMap = new Moments(avengeVelocity,distRemaining,veldir);
		List<Double> surfDistances = skidMap.getResults();
		long ticks = 0;		
		nextPosition = moments.pos;
		//double heading = moments.owner.heading;
	    for (Double surfVel : surfDistances){
			nextPosition = botUtils.project(nextPosition,surfVel*veldir/*(moments.currWave.latDirection<0?-1:1)/*surfVel*moments.owner.latDirection*/,heading);
		//	if(ticks == 0){
		//		theo.simple.gun.GHandler.nextPosition = nextPosition;
		//	}
			positionList.add(nextPosition);
			/*for(Point2D.Double pt : positionList){
				System.out.println(pt.toString());
			}*/
			ticks ++;
			double distanceFromShot = nextPosition.distance(moments.currWave.startPoint);
			distanceFromShot -= moments.currWave.distTraveled -
									(moments.currWave.velocity * ticks);
			if(distanceFromShot-moments.currWave.velocity<11 || surfVel <= 0){
				break;
			}
		}
		
		//for(Point2D.Double pos: positionList){
		//	ticks ++;
			
			
	//	}
	}
	
	protected void developEnemy(GHandler moments){
		
	}
	
	public List<Point2D.Double> getPosList(){
		return this.positionList;
	}

}

