package davidalves.net.radar;

import robocode.*;
import davidalves.net.*;
import davidalves.net.data.*;
import davidalves.net.radar.strategies.*;
import davidalves.net.util.*;
import java.util.*;
import java.io.*;

//So far just a transparent interface to antigravity, but I want room to grow
public class RadarManager implements Serializable{
	AbstractAdvancedBot me;
	EnvironmentInterface environment;
	RadarInterface[] radarMethod;

	int currentRadarMethod = 0;
	final int methodCount = 3;
	
	public RadarManager(AbstractAdvancedBot myBot, EnvironmentInterface myEnvironment){
		me = myBot;
		environment = myEnvironment;
		
		radarMethod = new RadarInterface[methodCount];
		radarMethod[0] = new FullSweepStrategy();
		radarMethod[1] = new MeleeStrategy(me, environment);
		radarMethod[2] = new DuelStrategy(me, environment);
	}
	
//	public void scan(){

//	}
	
	public void initialSweep(){
		me.setTurnRadarRight(100);
		me.setTurnGunRight(100);
		me.setTurnRight(100);
		me.execute();
	}
	
	public void manageRadar(){
		if (environment.targetLocked()){
			if (me.getOthers() == 1){
				currentRadarMethod = 2;
				//me.out.println("Using radar method: Duel");
			} else {
				currentRadarMethod = 1;
				//me.out.println("Using radar method: OptimalScanArcMethod");
			}
		} else {
			currentRadarMethod = 0; //Full sweep if not locked on a target yet
		}
		me.setTurnRadarRight(radarMethod[currentRadarMethod].scan());		
	}
}