/********************************************************************
* Enemy.java -- enemy robot class
*
* Date:	2002/Oct/14
* Author:	Matunaga Takateru
*
********************************************************************/
package tm;

import robocode.*;

public class Enemy {
	private String name;
	private double bearing;
	private double distance;
	private double heading;
	private double velocity;
	private double energy;
	private boolean update;			//ŐVXLꂽGH
	private boolean turn;
	private long mtime;				//ŏIXV
	private double absoluteBearing;		//G̐Ε
	private double x, y;				//W
	
	//------------------------------------------------------------------
	// getXXX() method
	//
	//
	//------------------------------------------------------------------
	public String getName() {
		return name;
	}
	
	public double getBearing() {
		return bearing;
	}
	
	public double getDistance() {
		return distance;
	}
	
	public double getHeading() {
		return heading;
	}
		
	public double getVelocity() {
		return velocity;
	}

	public double getEnergy() {
		return energy;
	}
	
	public boolean getTurn() {
		return turn;
	}

	public boolean getUpdate() {
		return update;
	}
	
	public long getMtime() {
		return mtime;
	}
	
	public double getAbsoluteBearing() {
		return absoluteBearing;
	}
	
	public double getX() {
		return x;
	}
	
	public double getY() {
		return y;
	}
	
	//------------------------------------------------------------------
	// setXXX() method
	//
	//
	//------------------------------------------------------------------
	public void setEnemy(ScannedRobotEvent e, double myHeading, long t, double myX, double myY) {
		name = e.getName();
		bearing = e.getBearing();
		distance = e.getDistance();
		heading = e.getHeading();
		velocity = e.getVelocity();
		energy = e.getEnergy();
		update = true;
		mtime = t;
		absoluteBearing = angleUnder180(bearing + myHeading);
		x = myX + Math.cos(Math.toRadians(90-absoluteBearing)) * distance;
		y = myY + Math.sin(Math.toRadians(90-absoluteBearing)) * distance;		
	}
	
	public void setName(String name) {
		this.name = name;
	}
	
	public void setBearing(double d) {
		bearing = d;
	}
	
	public void setDistance(double d) {
		distance = d;
	}
	
	public void setHeading(double d) {
		heading = d;
	}
	
	public void setVelocity(double d) {
		velocity = d;
	}

	public void setTurn(boolean b) {
		turn = b;
	}
	
	public void setUpdate(boolean b) {
		update = b;
	}
	
	//------------------------------------------------------------------
	// other method
	//
	//
	//------------------------------------------------------------------
	//---------------------------------------------------------------
	// angleUnder180() -- }180xȉ̊pxɒ
	//
	//---------------------------------------------------------------
	double angleUnder180(double deg) {
		if (deg > -180 && deg <= 180) return deg;
		
		if (deg > 180) return (deg - 360);
		else           return (360 + deg);
	}

}
