/* GoTo.java
 * Created on Jul 9, 2003
 * 
 * v 1.0 Basic GoTo movement.  myLocation must be the current location
 * for this to work.
 * 
 */
package jep.movement;

import java.awt.geom.Point2D;

import jep.Utils;
import robocode.AdvancedRobot;

/**
 * @author johnp
 * @version 1.0, Jul 9, 2003
 */
public class GoTo {
	private static Point2D.Double myLocation = new Point2D.Double(0, 0);
	/**
	 * @return
	 */
	public static Point2D.Double getMyLocation() {
		return myLocation;
	}

	/**
	 * @param double1
	 */
	public static void setMyLocation(Point2D.Double double1) {
		myLocation = double1;
	}
	
	/**
	 * @param x, y
	 */
	public static void setMyLocation(double x, double y) {
		myLocation = new Point2D.Double(x, y);
	}

	/**
	 * @param me -- the robot to move
	 * @param point -- the destination
	 */
	public static void goTo(AdvancedRobot me, Point2D.Double point) {
		double distance = myLocation.distance(point);
		double angle = Utils.normalRelativeAngle(Utils.absoluteBearing(myLocation, point) - me.getHeading());
		if (Math.abs(angle) > 90.0) {
			distance *= -1.0;
			if (angle > 0.0) {
				angle -= 180.0;
			} else {
				angle += 180.0;
			}
		}
		me.setTurnRight(angle);
		me.setAhead(distance);
	}
	
	/**
	 * @param me -- the robot to move
	 * @param x -- the x coordinate of the destination
	 * @param y -- the y coordinate of the destination
	 */
	public static void goTo(AdvancedRobot me, double x, double y) {
		goTo(me, new Point2D.Double(x, y));
	}
	
}
