package apv;

import robocode.*;
import java.awt.geom.Point2D;
import java.awt.geom.Line2D;

import apv.nrlibj.NNet;

/** ScruchiPu -  by Albert Prez 
* Uses external NeuralNetwork library - NRJLIB by Daniele Denaro
* 
* v0.6 First release
* v0.7 Different network topology, with an additional layer
*	   Some additional checks to ensure the feasibility of the solution	
*
*      NOTE: This source code does is from release 0.7, not from 1.0
*      I have to retain some competitive advantage :-)
*      I'm releasing the code to help people how a neural net can be applied to targeting.
*      My aim by releasing the code is to speed up the understanding on how NN apply and to
*      help generating ideas.
*      Because just coping code doesn't helps with this goals, please don't use this code 
*      on your bot. 
*      I removed also the movement code ....
*
*      The code is quite chaotic and uncommented - sorry about that :-)
*		  
*/		  

public class ScruchiPu extends AdvancedRobot {
	
	static final int embed = 40; //30
	static final int delay = 1; //2
	static final double VIN_SF = 2; //Input Vel. Scale factor
	static final double HIN_SF = 1; //Input Hed. Scale factor
	static final double VOUT_SF = 20; //Output Vel. Scale factor //12
	static final double HOUT_SF = 1; //Output Hed. Scale factor
		
	static String NNdescr[]=    
		{"layer=0 tnode=80 nname=NodeLin",        
  		 "layer=1 tnode=10  nname=NodeSigm", 
		 "layer=2 tnode=5  nname=NodeSigm",       
  		 "layer=3 tnode=2   nname=NodeSigm",       
  		 "linktype=all fromlayer=0 tolayer=1",   
  		 "linktype=all fromlayer=1 tolayer=2",
		 "linktype=all fromlayer=2 tolayer=3"};	
					
	static double[] ev = new double[100000];
	static double[] eh = new double[100000];
	static int n,m; 

	static String botname;
	static double predBearing;
	static double power;
	
	static double lastHeading; 
	static double eGetDistance;
	static double targetBearing;
	
	static NNet networkL = null; 
	static NNet networkC = null;
	
	public void run() {
		double nextMove, lastMove;
		double bestX, bestY, bestA;

		setAdjustRadarForGunTurn(true);
		setAdjustGunForRobotTurn(true); 
		
		nextMove = bestA = Math.PI; 
		lastMove = bestX = bestY = 2.0;
		power = 3;	
		predBearing = 0;
		
		do {
			double x = getX();
			double y = getY();
			//MOVE
			
			//... movement was here ...
			
			//RADAR
			if (getRadarTurnRemainingRadians() == 0) setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
			execute();
		} while (true); 
		
	}
	
	public void onScannedRobot(ScannedRobotEvent e) {
		botname = getBotClass(e.getName());
		if (networkL == null || networkC == null) {	
			try { networkL = new NNet(botname+".L",false,this); } catch (Exception ex) { networkL = new NNet(NNdescr); }
		}
		//RADAR
		setTurnRadarRightRadians(normalRelativeAngle((targetBearing=e.getBearingRadians() + getHeadingRadians())-getRadarHeadingRadians()) * 1.9);
		//ENEMY DATA (1)
		eGetDistance = e.getDistance();
		ps[n] = new Line2D.Double(getX(),getY(),getX()+eGetDistance*Math.sin(targetBearing),getY()+eGetDistance*Math.cos(targetBearing));
		ev[n] = e.getVelocity();
		eh[n] = normalRelativeAngle(e.getHeadingRadians()-lastHeading);			
		lastHeading = e.getHeadingRadians();
		//CALCULATE BEARINGS & TRAIN THE NETWORK		
		if (getTime()>embed*delay && e.getEnergy()>0) learn(networkL,n);
		//AIMING & FIRING
		if (e.getEnergy()>0 && n > 0) {
			predBearing = normalRelativeAngle(aim(networkL)-targetBearing);
		}
		else predBearing = 0;
		double gunturn = normalRelativeAngle(predBearing+targetBearing-getGunHeadingRadians());
		setTurnGunRightRadians(gunturn);	
		
		if( getEnergy()>power+0.1 && getGunHeat()==0 && Math.abs(gunturn)<0.06) { setFire(power); } 
		if ( getEnergy()<= 3) power = 0.2;

		n++;
		
	}	
	
	public void onWin(WinEvent event) { onDeath(null); }
	public void onDeath(DeathEvent e) {	if (getRoundNum()==getNumRounds()-1) { networkL.saveNNet(botname+".L",this); } } 
	
	public void learn(NNet network, int n) {
		float[] input = buildInput(n-1);
		float[] output = buildOutput(n-1); 
		if (input != null && output !=null) { network.ebplearnNNet(input,output); }
	}
	
	public double aim(NNet network) {
		double x = getX() + Math.sin(targetBearing)*eGetDistance; 
		double y = getY() + Math.cos(targetBearing)*eGetDistance;
		double ah = lastHeading;
		int time = 0;
		int match = n;
		float[] output = new float[2];
		double vel = 0;
		
		while ((time * (20.0 - 3.0 * power)) < Point2D.distance(getX(),getY(),x,y)) {	
			float[] input = buildInput(n+time);
			if (input != null) network.frwNNet(input,output); else { output[0] = 0; output[1] = 0; }
			vel = Math.max(-8,Math.min(8,(output[0]-0.5)*VOUT_SF));
			if (vel - ev[n+time] > 2) vel = ev[n+time] + 2;
			if (ev[n+time] - vel > 2) vel = ev[n+time] - 2;
			x += Math.sin(ah)*vel; x = Math.max(18,Math.min(getBattleFieldWidth()-18,x));
			y += Math.cos(ah)*vel; y = Math.max(18,Math.min(getBattleFieldHeight()-18,y));
			ev[n+time+1] = vel;	
			double hed = Math.max(-(0.17453293-0.01308997*Math.abs(vel)),Math.min(0.17453293-0.01308997*Math.abs(vel),(output[1]-0.5)*HOUT_SF));
			ah += hed;
			eh[n+time+1] = hed;
			time++;
		}
		return Math.atan2(x-getX(),y-getY());
	}
	
	//input N for output N+1 	
			
	public float[] buildInput(int n) {
		if (n<embed*delay) return null;
		else {
			float[] input = new float[embed*2];
			for (int i=0; i<embed; i++) { 
				input[2*i] = (float) (ev[n-i*delay]/VIN_SF); 
				input[2*i+1] = (float) (eh[n-i*delay]/HIN_SF); 
			}
			return input;
		}
	}	
	
	public float[] buildOutput(int n) {
		if (n<0) return null;
		else { 
			float[] output = new float[2]; output[0] = (float) ((ev[n+1]/VOUT_SF) + 0.5); output[1] = (float) ((eh[n+1]/HOUT_SF)+0.5);
			return output;
		}
	}	
																		
	private double normalRelativeAngle(double angle) { return ((angle + 5*Math.PI) % (2*Math.PI)) - Math.PI; }
	
	private double scoring(double a1) { return Math.abs(Math.abs(normalRelativeAngle(a1))-Math.PI/2); }		
		
	private double newpos(double len) { return 100 + Math.random()*(len-200); }	
	
	private String getBotClass(String name) { String n = name; int low = name.indexOf(" "); if (low >= 0) n = name.substring(0, low);  return n; }		
          
}			