/*
 * Decompiled with CFR 0.152.
 */
package catcat20.core.gun.pm;

import catcat20.core.bot.Bot;
import catcat20.core.gun.Gun;
import catcat20.core.radar.Radar;
import catcat20.core.utils.LUtils;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import robocode.RoundEndedEvent;
import robocode.Rules;
import robocode.TeamRobot;

public class SingleTick
extends Gun {
    private static final int MAX_PATTERN_LENGTH = 30;
    private static List<Point2D.Double> predictions = new ArrayList<Point2D.Double>();

    public SingleTick(TeamRobot _robot) {
        super(_robot);
    }

    @Override
    public void init() {
        for (Bot bot : Radar.enemyList) {
            bot.enemyHistory = "";
        }
    }

    @Override
    public void execute() {
    }

    @Override
    public void onRoundEnded(RoundEndedEvent e) {
    }

    @Override
    public double getAngle(double power) {
        Point2D.Double myPos = new Point2D.Double(this._robot.getX(), this._robot.getY());
        Bot bot = Radar.nearestBot;
        if (bot != null && bot.isAlive && bot.currentState != null && bot.states.size() > 2) {
            double absoluteBearing = LUtils.absoluteBearing(myPos.x, myPos.y, bot.currentState.x, bot.currentState.y);
            double enemyH = bot.currentState.heading;
            int enemyV = (int)Math.rint(bot.currentState.velocity);
            int thisStep = SingleTick.encode(enemyH - bot.states.get((int)1).heading, enemyV);
            if (thisStep == 65535) {
                return Double.POSITIVE_INFINITY;
            }
            this.record(bot, thisStep);
            bot.enemyHistory = (char)thisStep + bot.enemyHistory;
            predictions.clear();
            Point2D.Double enemyP = new Point2D.Double(bot.currentState.x, bot.currentState.y);
            Object pattern = bot.enemyHistory;
            for (double d = 0.0; d < myPos.distance(enemyP); d += Rules.getBulletSpeed((double)power)) {
                int nextStep = this.predict(bot, (String)pattern);
                enemyV = SingleTick.decodeV(nextStep);
                enemyP = LUtils.project(enemyP, enemyH += SingleTick.decodeDH(nextStep), enemyV);
                predictions.add(enemyP);
                pattern = (char)nextStep + (String)pattern;
            }
            absoluteBearing = Math.atan2(enemyP.x - myPos.x, enemyP.y - myPos.y);
            return absoluteBearing;
        }
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public Color getColor() {
        return Color.yellow;
    }

    @Override
    public String getLabel() {
        return "AntiSurfer PM";
    }

    @Override
    public void onPaint(Graphics2D g) {
        g.setColor(Color.WHITE);
        for (Point2D.Double p : predictions) {
            g.fillOval((int)p.x - 1, (int)p.y - 1, 3, 3);
        }
    }

    private void record(Bot bot, int thisStep) {
        int maxLength = Math.min(30, bot.enemyHistory.length());
        for (int i = 0; i <= maxLength; ++i) {
            String pattern = bot.enemyHistory.substring(0, i);
            int[] frequencies = bot.matcher.get(pattern);
            if (frequencies == null) {
                frequencies = new int[357];
                bot.matcher.put(pattern, frequencies);
            }
            int n = thisStep;
            frequencies[n] = frequencies[n] + 1;
        }
    }

    private int predict(Bot bot, String pattern) {
        int[] frequencies = null;
        int patternLength = Math.min(pattern.length(), 30);
        while (frequencies == null) {
            frequencies = bot.matcher.get(pattern.substring(0, patternLength));
            --patternLength;
        }
        int nextTick = 0;
        for (int i = 1; i < frequencies.length; ++i) {
            if (frequencies[nextTick] >= frequencies[i]) continue;
            nextTick = i;
        }
        return nextTick;
    }

    private static int encode(double dh, int v) {
        if (Math.abs(dh) > Rules.MAX_TURN_RATE_RADIANS) {
            return 65535;
        }
        int dhCode = (int)Math.rint(Math.toDegrees(dh)) + 10;
        int vCode = v + 8;
        return (char)(17 * dhCode + vCode);
    }

    private static double decodeDH(int symbol) {
        return Math.toRadians((double)symbol / 17.0 - 10.0);
    }

    private static int decodeV(int symbol) {
        return symbol % 17 - 8;
    }

    public static class LRUMap<K, T>
    extends LinkedHashMap<K, T> {
        private final int maxSize;
        private boolean hitCap = false;

        public LRUMap(int maxSize) {
            super((int)((double)maxSize / 0.75) + 2, 0.75f, true);
            this.maxSize = maxSize;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, T> eldest) {
            if (this.size() > this.maxSize) {
                if (!this.hitCap) {
                    System.out.println("Hit memory cap (" + this.maxSize + ")");
                    this.hitCap = true;
                }
                return true;
            }
            return false;
        }
    }
}

