/*
 * Decompiled with CFR 0.152.
 */
package catcat20.core.utils;

import java.awt.geom.Point2D;
import java.awt.geom.RoundRectangle2D;

public class LUtils {
    private static final double HALF_PI = 1.5707963267948966;
    private static final double TWO_PI = Math.PI * 2;

    private LUtils() {
    }

    public static int bulletTicksFromPower(double distance, double power) {
        return (int)Math.ceil(distance / (20.0 - 3.0 * power));
    }

    public static double bulletPowerFromVelocity(double velocity) {
        return (20.0 - velocity) / 3.0;
    }

    public static double normalizeAngle(double angle, double reference) {
        double normDiff = reference - angle;
        while (Math.abs(normDiff) > Math.PI) {
            normDiff = reference - (angle += Math.signum(normDiff) * (Math.PI * 2));
        }
        return angle;
    }

    public static double maxEscapeAngle(double bulletVelocity) {
        return Math.asin(8.0 / bulletVelocity);
    }

    public static double square(double d) {
        return d * d;
    }

    public static double cube(double d) {
        return d * d * d;
    }

    public static Point2D.Double project(Point2D.Double sourceLocation, double angle, double length) {
        return new Point2D.Double(sourceLocation.x + Math.sin(angle) * length, sourceLocation.y + Math.cos(angle) * length);
    }

    public static Point2D.Double projectWithCache(Point2D.Double sourceLocation, double angle, double length, Point2D.Double cache) {
        cache.setLocation(sourceLocation.x + Math.sin(angle) * length, sourceLocation.y + Math.cos(angle) * length);
        return cache;
    }

    public static double absoluteBearing(Point2D.Double source, Point2D.Double target) {
        return Math.atan2(target.x - source.x, target.y - source.y);
    }

    public static double absoluteBearing(double sx, double sy, double tx, double ty) {
        return Math.atan2(tx - sx, ty - sy);
    }

    public static int sign(double v) {
        return v < 0.0 ? -1 : 1;
    }

    public static double limit(double min, double value, double max) {
        return Math.max(min, Math.min(value, max));
    }

    public static int limit(int min, int value, int max) {
        return Math.max(min, Math.min(value, max));
    }

    public static double accel(double velocity, double previousVelocity) {
        double accel = velocity - previousVelocity;
        accel = previousVelocity == 0.0 ? Math.abs(accel) : (accel *= Math.signum(previousVelocity));
        return accel;
    }

    public static double sigmoid(double x) {
        return 1.0 / (1.0 + Math.exp(-x));
    }

    public static void projectToBoundary(RoundRectangle2D rr, double px, double py, Point2D.Double cache) {
        double x = rr.getX();
        double y = rr.getY();
        double w = rr.getWidth();
        double h = rr.getHeight();
        double rx = rr.getArcWidth() / 2.0;
        double ry = rr.getArcHeight() / 2.0;
        double innerLeft = x + rx;
        double innerRight = x + w - rx;
        double innerTop = y + ry;
        double innerBottom = y + h - ry;
        if (rr.contains(px, py)) {
            cache.setLocation(px, py);
            return;
        }
        if (px >= innerLeft && px <= innerRight) {
            if (py < y) {
                cache.setLocation(px, y);
                return;
            }
            if (py > y + h) {
                cache.setLocation(px, y + h);
                return;
            }
        }
        if (py >= innerTop && py <= innerBottom) {
            if (px < x) {
                cache.setLocation(x, py);
                return;
            }
            if (px > x + w) {
                cache.setLocation(x + w, py);
                return;
            }
        }
        double cx = 0.0;
        double cy = 0.0;
        if (px < innerLeft && py < innerTop) {
            cx = innerLeft;
            cy = innerTop;
        } else if (px > innerRight && py < innerTop) {
            cx = innerRight;
            cy = innerTop;
        } else if (px < innerLeft && py > innerBottom) {
            cx = innerLeft;
            cy = innerBottom;
        } else if (px > innerRight && py > innerBottom) {
            cx = innerRight;
            cy = innerBottom;
        }
        double dx = px - cx;
        double dy = py - cy;
        if (dx == 0.0 && dy == 0.0) {
            cache.setLocation(cx + rx, cy);
            return;
        }
        double nx = dx / rx;
        double ny = dy / ry;
        double len = Math.sqrt(nx * nx + ny * ny);
        double ex = cx + (nx /= len) * rx;
        double ey = cy + (ny /= len) * ry;
        cache.setLocation(ex, ey);
    }
}

