/*
 * Decompiled with CFR 0.152.
 */
package catcat20.core.utils;

import catcat20.core.utils.LUtils;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import robocode.util.Utils;

public class MovementPredictor {
    public static PredictionStatus predict(PredictionStatus status, double goAngle) {
        return MovementPredictor.predict(status, goAngle, 8.0);
    }

    public static PredictionStatus predict(PredictionStatus status, double goAngle, double maxVelocity) {
        int moveDir = 1;
        if (Math.cos(goAngle - status.heading) < 0.0) {
            moveDir = -1;
        }
        PredictionStatus predictedStatus = MovementPredictor._predict(status, goAngle, maxVelocity, Double.POSITIVE_INFINITY * (double)moveDir);
        predictedStatus.direction = moveDir;
        return predictedStatus;
    }

    public static List<PredictionStatus> predict(PredictionStatus status, double goAngle, double maxVelocity, double distanceRemaining) {
        ArrayList<PredictionStatus> predicted = new ArrayList<PredictionStatus>(20);
        predicted.add(status);
        while (distanceRemaining > 0.0) {
            status = MovementPredictor._predict(status, goAngle, maxVelocity, distanceRemaining);
            predicted.add(status);
            distanceRemaining -= status.velocity;
        }
        return predicted;
    }

    public static List<PredictionStatus> predict(PredictionStatus status, int tick, double goAngle, double maxVelocity) {
        ArrayList<PredictionStatus> predicted = new ArrayList<PredictionStatus>(tick + 2);
        predicted.add(status);
        while (tick-- > 0) {
            status = MovementPredictor.predict(status, goAngle, maxVelocity);
            predicted.add(status);
        }
        return predicted;
    }

    public static List<PredictionStatus> predict(PredictionStatus status, int tick, double goAngle, double maxVelocity, double distanceRemaining) {
        ArrayList<PredictionStatus> predicted = new ArrayList<PredictionStatus>(tick + 2);
        predicted.add(status);
        while (distanceRemaining > 0.0 && tick-- > 0) {
            status = MovementPredictor._predict(status, goAngle, maxVelocity, distanceRemaining);
            predicted.add(status);
            distanceRemaining -= status.velocity;
        }
        return predicted;
    }

    private static PredictionStatus _predict(PredictionStatus status, double goAngle, double maxVelocity, double distanceRemaining) {
        double x = status.x;
        double y = status.y;
        double heading = status.heading;
        double velocity = status.velocity;
        if (Math.cos(goAngle -= heading) < 0.0) {
            goAngle += Math.PI;
        }
        goAngle = Utils.normalRelativeAngle((double)goAngle);
        double maxTurning = Math.toRadians(10.0 - 0.75 * velocity);
        velocity = MovementPredictor.getVelocity(velocity, maxVelocity, distanceRemaining);
        return new PredictionStatus(x += Math.sin(heading += LUtils.limit(-maxTurning, goAngle, maxTurning)) * velocity, y += Math.cos(heading) * velocity, heading, velocity, status.time + 1L);
    }

    private static void _predict(PredictionStatus status, double goAngle, double maxVelocity, double distanceRemaining, PredictionStatus destination) {
        double x = status.x;
        double y = status.y;
        double heading = status.heading;
        double velocity = status.velocity;
        if (Math.cos(goAngle -= heading) < 0.0) {
            goAngle += Math.PI;
        }
        goAngle = Utils.normalRelativeAngle((double)goAngle);
        double maxTurning = Math.toRadians(10.0 - 0.75 * velocity);
        velocity = MovementPredictor.getVelocity(velocity, maxVelocity, distanceRemaining);
        x += Math.sin(heading += LUtils.limit(-maxTurning, goAngle, maxTurning)) * velocity;
        y += Math.cos(heading) * velocity;
        if (destination == null) {
            destination = new PredictionStatus(x, y, heading, velocity, status.time + 1L);
        }
        destination.x = x;
        destination.y = y;
        destination.heading = heading;
        destination.velocity = velocity;
        destination.time = status.time + 1L;
        destination.direction = status.direction;
    }

    public static double getVelocity(double currentVelocity, double maxVelocity, double distanceRemaining) {
        if (distanceRemaining < 0.0) {
            return -MovementPredictor.getVelocity(-currentVelocity, maxVelocity, -distanceRemaining);
        }
        double newVelocity = currentVelocity;
        double maxSpeed = Math.abs(maxVelocity);
        double currentSpeed = Math.abs(currentVelocity);
        if (currentVelocity < 0.0 || currentSpeed > maxSpeed) {
            newVelocity = currentSpeed - 2.0;
            if (newVelocity < 0.0) {
                double decelTime = currentSpeed / 2.0;
                double accelTime = 1.0 - decelTime;
                newVelocity = Math.min(maxSpeed, Math.min(2.0 * decelTime * decelTime + 1.0 * accelTime * accelTime, distanceRemaining));
                currentVelocity *= -1.0;
            }
        } else {
            double decelTime = currentSpeed / 2.0;
            double decelDist = 1.0 * decelTime * decelTime + decelTime;
            if (distanceRemaining <= decelDist) {
                double time = distanceRemaining / (decelTime + 1.0);
                if (time <= 1.0) {
                    newVelocity = Math.max(currentSpeed - 2.0, distanceRemaining);
                } else {
                    newVelocity = time * 2.0;
                    if (currentSpeed < newVelocity) {
                        newVelocity = currentSpeed;
                    } else if (currentSpeed - newVelocity > 2.0) {
                        newVelocity = currentSpeed - 2.0;
                    }
                }
            } else {
                newVelocity = Math.min(currentSpeed + 1.0, maxSpeed);
            }
        }
        return currentVelocity < 0.0 ? -newVelocity : newVelocity;
    }

    public static class PredictionStatus
    extends Point2D.Double {
        private static final long serialVersionUID = 4116202515905711057L;
        public double heading;
        public double velocity;
        public long time;
        public int direction = 1;

        public PredictionStatus(double x, double y, double h, double v, long t) {
            super(x, y);
            this.heading = h;
            this.velocity = v;
            this.time = t;
        }

        public PredictionStatus(double x, double y, double h, double v, long t, int direction) {
            super(x, y);
            this.heading = h;
            this.velocity = v;
            this.time = t;
            this.direction = direction;
        }
    }
}

