package ers.micro.speusippus;
 
/**
 * Creator: ER Samson
 * 
 * Credits:
 * Movement - https://mark.random-article.com/robocode/improved_movement.html
 * 			- https://robowiki.net/wiki/User:Exauge/snippets
 *          - https://robowiki.net/wiki/Oscillator_Movement
 * 
 * Radar - http://robowiki.net/wiki/One_on_One_Radar
 * 
 * Gun Targeting - https://robowiki.net/wiki/Aristocles
 *               - https://robowiki.net/wiki/GuessFactor_Targeting_Tutorial
 * 
 * Tips from Sheldor and Skilgannon's Yatagan - https://robowiki.net/wiki/Yatagan
 */

import robocode.*;
import robocode.util.Utils;
//import java.awt.*;
import java.awt.geom.*;

public class Speusippus extends AdvancedRobot {

	// Guess Factor Variables
	private static final double 	BATTLE_FIELD_WIDTH 		= 800;
    private static final double 	BATTLE_FIELD_HEIGHT 	= 600;
    private static final double 	MAX_DISTANCE 			= 900;
    private static final double 	BULLET_POWER 			= 2.0;
    private static final double 	WALL_MARGIN 			= 36;

    private static final int 		DISTANCE_INDEXES 		= 5;
    private static final int 		VELOCITY_INDEXES 		= 5;
    private static final int 		LAST_VELOCITY_INDEXES 	= 5;
	private static final int		FIRE_VELOCITY_INDEXESE	= 5;
    private static final int 		WALL_INDEXES 			= 2;
    //private static final int 		DECCEL_TIME_INDEXES 	= 6;
    private static final int 		AIM_FACTORS 			= 25;
    private static final int 		MIDDLE_FACTOR 			= (AIM_FACTORS - 1) / 2;

    private static Point2D 			enemyLocation;
	private static double 			bearingDirection;
    private static double 			enemyVelocity;
    //private static int 				timeSinceDeccel;

    private static int[][][][][][] 	aimFactors 				= new int[DISTANCE_INDEXES][VELOCITY_INDEXES][LAST_VELOCITY_INDEXES]
											   					[FIRE_VELOCITY_INDEXESE][WALL_INDEXES][AIM_FACTORS];

	// Movement Variables
	private static final int	 	DISTANCE_FACTOR			= 3000;
	private static final int	 	TARGET_DISTANCE			= 180;
	private static final double		DODGE_FACTOR			= 0.13; // ~0.17 best vs PM guns
	private static final int 		ANTIRAM_FACTOR 			= 70;
	private static double 			enemyEnergy;
	private static double 			moveDistance;
	private static double 			moveMode 				= 1;
	private static double 			stopDistance 			= 72;
	private static int 				deathCount;
	private static int				fireVelocityIndex;

	public void run() {
		// Color Identification
		//setColors(Color.blue, Color.red, Color.orange);
		
        setAdjustRadarForGunTurn(true);
        setAdjustGunForRobotTurn(true);
		//setTurnRadarRightRadians(moveDistance = Double.POSITIVE_INFINITY);
		do {
			turnRadarRightRadians(moveDistance = Double.POSITIVE_INFINITY);
		} while (true);
	}

	public void onScannedRobot(ScannedRobotEvent e) {

		Wave wave = new Wave();
		double enemyDistance;
		double enemyAbsoluteBearing;

		Rectangle2D fieldRectangle = new Rectangle2D.Double(WALL_MARGIN, 
															WALL_MARGIN,
		    												BATTLE_FIELD_WIDTH - WALL_MARGIN * 2, 
															BATTLE_FIELD_HEIGHT - WALL_MARGIN * 2);		

		// ---------- Musashi Movement Logic ----------
		// Turn perpendicular to enemy, try to maintain distance, no wall avoidance D: 
	    // setTurnRightRadians(Math.cos((absB = e.getBearingRadians()) - (0.2 * mvD))); // Saving code size!
		// Movement based from Yatagan Nano
		setTurnRightRadians(Math.cos((enemyAbsoluteBearing = e.getBearingRadians()) + 
						   (TARGET_DISTANCE - (enemyDistance = e.getDistance())) * (getVelocity() / DISTANCE_FACTOR)));

		// ---------- Multi-Mode Movement ----------
		// Multi-mode oscillation switch idea from several bots (Yatagan, PraldeGuerre)
		// 0, 2 = one-way direction
		// 1, 3 = two-way oscillation
		// 4 = random oscillation
		// 5 = energy drop, one/two-way oscillcation on BulletHit logic

		if (deathCount > 4) {
			if ((char)(enemyEnergy - 1 - (enemyEnergy = e.getEnergy())) < 4) {
				setAhead(stopDistance *= moveMode);
			}
		} else {
			setAhead(moveDistance *= (Math.random() - DODGE_FACTOR)
					+ ((int)(4 / (1 + deathCount))));
			if ((char)(enemyEnergy - 1 - (enemyEnergy = e.getEnergy())) < 4 
					&& (deathCount % 2) != 0 && deathCount < 4) {
				onHitWall(null);
			}			
		}

		// ---------- Gun Logic ----------
		// GuessFactor Targeting Gun - Aristocles
		// Only with *VERY* minor edits
		enemyLocation = project(wave.wGunLocation = new Point2D.Double(getX(), getY()), 
                               (enemyAbsoluteBearing += getHeadingRadians()), enemyDistance);		

		int lastVelocityIndex = (int)Math.abs(enemyVelocity) / 2;
		int velocityIndex = (int)Math.abs((enemyVelocity = e.getVelocity()) / 2);	

		//if (velocityIndex < lastVelocityIndex) {
		 //  timeSinceDeccel = 0;
		//}
		if (enemyVelocity != 0) {
	    	bearingDirection = enemyVelocity * Math.sin(e.getHeadingRadians() - enemyAbsoluteBearing) > 0 ?
				0.7 / (double)MIDDLE_FACTOR : -0.7 / (double)MIDDLE_FACTOR;
		}

		wave.wBearingDirection = bearingDirection;
		int distanceIndex = (int)(enemyDistance / (MAX_DISTANCE / DISTANCE_INDEXES));
		//wave.wBulletPower = Math.min(enemyEnergy / 4,
	    //	(distanceIndex = (int)(enemyDistance / (MAX_DISTANCE / DISTANCE_INDEXES))) > 1 ? BULLET_POWER : MAX_BULLET_POWER);
		// Removed original bullet power code from Aristocles
		wave.wBulletPower = Math.min(BULLET_POWER + (int)(ANTIRAM_FACTOR / enemyDistance), enemyEnergy / 4);
		
		wave.wAimFactors = aimFactors[distanceIndex][velocityIndex]
								     [lastVelocityIndex][fireVelocityIndex]/*[Math.min(5, timeSinceDeccel++ / 13)]*/
	    	                         [fieldRectangle.contains(project(wave.wGunLocation, 
                                     	enemyAbsoluteBearing + wave.wBearingDirection * 13, enemyDistance)) ?
										1 : 0];
		wave.wBearing = enemyAbsoluteBearing;

		int mostVisited = MIDDLE_FACTOR, i = AIM_FACTORS;
		do  {
	    	if (wave.wAimFactors[--i] > wave.wAimFactors[mostVisited]) {
				mostVisited = i;
	    	}
		} while (i > 0);

		setTurnGunRightRadians(Utils.normalRelativeAngle(enemyAbsoluteBearing - getGunHeadingRadians() +
	    	wave.wBearingDirection * (mostVisited - MIDDLE_FACTOR)));

		//setFire(wave.wBulletPower);

		if (setFireBullet(wave.wBulletPower) != null) {
			fireVelocityIndex = velocityIndex;
		}		

		if (getEnergy() >= BULLET_POWER) {
	    	addCustomEvent(wave);
		}

		// ---------- Radar Logic ---------- 
		// From RoboWiki
		//setTurnRadarLeft(getRadarTurnRemaining()); // This Line saves code size by 10
		setTurnRadarRightRadians(2 * Utils.normalRelativeAngle(enemyAbsoluteBearing - getRadarHeadingRadians()));
	}

	public void onHitWall(HitWallEvent e) {
		moveDistance = -moveDistance;
		stopDistance = -stopDistance;
		//onHitByBullet(null); // only being used by State 5
	}
	
	/**
	 * Switcher to Oscillation
	 */
	public void onHitByBullet(HitByBulletEvent e) {
		moveMode = -moveMode;
	}
	
	/**
	 * Switches between 5 States
	 */
	public void onDeath(DeathEvent e) {
		// Increment the deathCount variable.
		// Multi-mode, only uses last 2 states for general "combat"
		deathCount++;
		if (deathCount > 5) {
			deathCount = 4;
		}
	}	

    public static Point2D project(Point2D sourceLocation, double angle, double length) {
        return new Point2D.Double(sourceLocation.getX() + Math.sin(angle) * length,
            sourceLocation.getY() + Math.cos(angle) * length);
    }

    public static double absoluteBearing(Point2D source, Point2D target) {
        return Math.atan2(target.getX() - source.getX(), target.getY() - source.getY());
    }

	public class Wave extends Condition {
		double wBulletPower;
		Point2D wGunLocation;
		double wBearing;
		double wBearingDirection;
		int[] wAimFactors;
		double wDistance;

		public boolean test() {
			if ((wDistance += (Rules.getBulletSpeed(wBulletPower))) > wGunLocation.distance(enemyLocation) - 18) {
				try {
		    		wAimFactors[(int)Math.round(((Utils.normalRelativeAngle(absoluteBearing(wGunLocation, enemyLocation) - wBearing)) /
						wBearingDirection) + MIDDLE_FACTOR)]++;
				} catch (Exception e) {
				}
				removeCustomEvent(this);
	    	}
	    	return false;
		}
	}
}


