package ers.nano.flattery;

/**
 * Author: ER Samson
 * 
 * "Imitation is the sincerest form of flattery."
 * "An obsession is a way for damaged people to damage themselves more."
 * 
 * This design has evolved to
 * 		• PM Gun
 * 		• Direction Change Detector / Copy Cat (with some randomness)
 * 
 *  -- Credits to the following --
 * Heavy influence coming from both Yatagan and NeophytePRAL as their multi-mode
 * movement really crushes this robot. I also like the idea of ButtHead and Sabreur.
 * Goal now is to create a bot without look-up tables since I'm too dumb to use it.
 * Carried iterations from LigMA, Sunderer, Sawcon and HawkLA
 * 
 * Movement:
 * 		• Mark Whiteley      - http://mark.random-article.com/robocode/improved_movement.html
 * 		• Wiki               - https://robowiki.net/wiki/User:Exauge/snippets
 *		• Wiki               - https://robowiki.net/wiki/Stop_And_Go_Tutorial
 * 		• Wiki               - https://robowiki.net/wiki/Oscillator_Movement
 * 		• Sheldor/Skilgannon - https://robowiki.net/wiki/Yatagan
 * 		• John Cleland       - https://robowiki.net/wiki/NeophytePRAL
 *		• Sheldor			  - https://robowiki.net/wiki/Sabreur
 * 
 * Radar:
 * 		• Wiki               - https://robowiki.net/wiki/One_on_One_Radar
 * 
 * Gun Targeting:
 * 		• Wiki               - https://robowiki.net/wiki/Rolling_Averages
 *		• Exauge             - https://robowiki.net/wiki/User:Exauge/snippets
 * 		• Sheldor            - https://robowiki.net/wiki/Foilist
 * 		• Sheldor/Skilgannon - https://robowiki.net/wiki/Yatagan
 *      • Simonton          - https://robowiki.net/wiki/WeekendObsession
 * 		• John Cleland       - https://robowiki.net/wiki/NeophytePRAL
 * 		• Sheldor			  - https://robowiki.net/wiki/Sabreur
 * 
 * Code Shrinking Tips:
 * 		• Sheldor/Skilgannon - https://robowiki.net/wiki/Yatagan
 *      • Simonton           - https://robowiki.net/wiki/WeekendObsession
 * 
 */

import robocode.*;
import robocode.util.Utils;
//import java.awt.*;

public class Flattery extends AdvancedRobot {

	/* ---------- Movement Variables ---------- */
	private static final double	BIG_NUMBER			= 3000;
	private static final double	TARGET_DISTANCE	= 180;
	private static final double	RANDOM_FACTOR		= 20;
	private static double 		moveDirection;
	private static double 		enemyVelocity;
	
	/* ---------- Gun Variables ---------- */
	private static final int		BULLET_POWER		= 2;
	private static final int		BULLET_VELOCITY	= (int)(20 - 3 * BULLET_POWER);
	private static final int		ANTIRAM_FACTOR		= 72;
	private static final int		PATTERN_DEPTH		= 30;

	public void run() {
		// Color Identification
		//setColors(Color.blue, Color.red, Color.orange);

		// Easy targeting and infinite radar movement
		setAdjustGunForRobotTurn(true); // Saving code size!
		setTurnRadarRightRadians(moveDirection = Double.POSITIVE_INFINITY);
	}

	public void onScannedRobot(ScannedRobotEvent e) {
	
		/* ---------- Generic Variables ---------- */
		// Arranged like so to save codesize!
		int matchLength = PATTERN_DEPTH;
		double targetBearing;
		double enemyDistance;
		int patternIndex;  
		int tickIndex;

		/* ---------- Movement Logic ----------	*/
		// Turn perpendicular to enemy, no wall avoidance D:
		// CREDIT: Yatagan
		setTurnRightRadians(Math.cos((targetBearing = e.getBearingRadians()) + 
				((TARGET_DISTANCE - (enemyDistance = e.getDistance())) 
				* (getVelocity() / BIG_NUMBER))));

		// Copy Cat Movement with 5% random motion
		if (enemyVelocity * ((enemyVelocity = e.getVelocity() - 0.2)) < 0) { 
			onHitWall(null);
		}
		setAhead(moveDirection *= (Math.random() - (double)1 / RANDOM_FACTOR));

		/* ---------- Gun Logic ---------- */
		// PM Gun from Exauge in RoboWiki
		// Experimenting with StringBuilder but this saves 10-12 bytes
		enemyHistory = String.valueOf((char)(e.getVelocity() 
             	* Math.sin(e.getHeadingRadians() - (targetBearing 
				+= getHeadingRadians())))).concat(enemyHistory);

		while((patternIndex = enemyHistory.indexOf(enemyHistory.substring(0, matchLength--), 
				tickIndex = (int) enemyDistance / BULLET_VELOCITY)) < 0);

		do {
				targetBearing += (byte)enemyHistory.charAt(patternIndex--) / enemyDistance; 
		} while (tickIndex-- > 0);		

		setTurnGunRightRadians(Utils.normalRelativeAngle(targetBearing - getGunHeadingRadians()));
		
		// Shoot to kill, with Anti-Ram
		setFire(BULLET_POWER + (int)(ANTIRAM_FACTOR / enemyDistance)); 	

		/* ---------- Radar Logic ---------- */
		// From RoboWiki
		setTurnRadarLeft(getRadarTurnRemaining());		
	}

	/**
	 * Reverse direction when I hit wall
	 */
	public void onHitWall(HitWallEvent e) {
		moveDirection = -moveDirection;
	}

	/**
	 * Symbolic log of enemy movements for pattern matcher.
	 * Preloaded to prevent StringIndexOutOfBoundsException.
	 */
	private static String enemyHistory = ""
		+ (char) 0 + (char) 26 + (char) 8 + (char) 35 + (char) 2 + (char) 47 
		+ (char) 0 + (char) 26 + (char) 8 + (char) 35 + (char) 2 + (char) 47 
		+ (char) 0 + (char) 26 + (char) 8 + (char) 35 + (char) 2 + (char) 47 
		+ (char) 0 + (char) 26 + (char) 8 + (char) 35 + (char) 2 + (char) 47 
		+ (char) 0 + (char) 26 + (char) 8 + (char) 35 + (char) 2 + (char) 47;
}