/*
 * Decompiled with CFR 0.152.
 */
package pedersen.physics;

import pedersen.core.Constraints;
import pedersen.debug.Debug;
import pedersen.physics.StaticHeading;

public class StaticHeadingImpl
implements StaticHeading {
    private final double heading;

    public StaticHeadingImpl(double newHeading) {
        this.heading = newHeading;
    }

    public StaticHeadingImpl(StaticHeading other) {
        this.heading = other.getHeading();
    }

    public double getHeading() {
        return this.heading;
    }

    public boolean equalsAngle(double other) {
        return Constraints.isApproximatelyZero(this.getRelativeAngle(other));
    }

    public boolean equalsAngle(StaticHeading other) {
        return this.equalsAngle(other.getHeading());
    }

    public double getRelativeAngle(double other) {
        return Constraints.getNegativePiToPi(other - this.heading);
    }

    public double getRelativeAngle(StaticHeading other) {
        return this.getRelativeAngle(other.getHeading());
    }

    public double getCompoundAngle(double other) {
        return Constraints.getZeroToTwoPi(this.heading + other);
    }

    public double getCompoundAngle(StaticHeading other) {
        return Constraints.getZeroToTwoPi(this.heading + other.getHeading());
    }

    public void debug() {
        Debug.debug("Static heading: " + this.getHeading());
    }
}

