/*
 * Decompiled with CFR 0.152.
 */
package florent.XSeries.movement.antigravity;

import florent.XSeries.Configuration;
import florent.XSeries.movement.antigravity.GravPoint;
import florent.XSeries.team.XBullet;
import florent.XSeries.utils.Force;
import florent.XSeries.utils.RobocodeTools;
import java.awt.geom.Point2D;

public class TeamBulletPoint
extends GravPoint {
    private XBullet bullet;

    public TeamBulletPoint(XBullet bullet) {
        this.bullet = bullet;
        this.point = bullet.getLocation(Configuration.time);
    }

    public String getKey() {
        return "TeamBullet:" + super.getKey();
    }

    protected double getMagnitude(Point2D.Double location) {
        this.point = this.bullet.getLocation(Configuration.time);
        boolean comingCloser = this.point.distanceSq(location) < this.bullet.getLocation(Configuration.time - 1L).distanceSq(location);
        this.strength = comingCloser || this.point.distance(location) < 20.0 ? 50 : 0;
        this.strength = this.strength == Double.POSITIVE_INFINITY ? 1.0 : this.strength;
        return super.getMagnitude(location);
    }

    public Force getForce(Point2D.Double location) {
        double angle = RobocodeTools.absoluteBearing(location, this.bullet.getOrigin()) + 1.5707963267948966 * (double)RobocodeTools.sign(RobocodeTools.angleBetween(this.bullet.getOrigin(), location, this.point));
        double magnitude = this.getMagnitude(location);
        Point2D.Double end = new Point2D.Double(location.x + magnitude * Math.sin(angle), location.y + magnitude * Math.cos(angle));
        return new Force(location, end);
    }
}

