/*
 * Decompiled with CFR 0.152.
 */
package eem;

import eem.botVersion;
import eem.bullets.bulletsManager;
import eem.gun.baseGun;
import eem.gun.gunManager;
import eem.misc.logger;
import eem.misc.math;
import eem.misc.physics;
import eem.motion.basicMotion;
import eem.motion.dangerMapMotion;
import eem.radar.radar;
import eem.target.InfoBot;
import eem.target.botStatPoint;
import eem.target.botsManager;
import eem.target.target;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import robocode.AdvancedRobot;
import robocode.Bullet;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitWallEvent;
import robocode.RobocodeFileWriter;
import robocode.RobotDeathEvent;
import robocode.RoundEndedEvent;
import robocode.Rules;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.WinEvent;

public class EvBot
extends AdvancedRobot {
    public Rules game_rules;
    double BodyTurnRate = 10.0;
    public int robotHalfSize = 18;
    public long ticTime;
    public int roundCnt = 0;
    int nonexisting_coord = -10000;
    public int totalNumOfEnemiesAtStart = 0;
    public static int roundsWon = 0;
    public static int roundsLost = 0;
    public static int[] finishingPlacesStats = null;
    public static int[] skippedTurnStats = null;
    public static int bulletFiredCnt = 0;
    public static int bulletHitCnt = 0;
    public static int bulletHitByPredictedCnt = 0;
    private static int numTicsWhenGunInColdState = 0;
    private botVersion botVer;
    public target _trgt;
    private baseGun _gun;
    public radar _radar;
    public basicMotion _motion;
    public bulletsManager _bmanager;
    public gunManager _gmanager;
    public botsManager _botsmanager;
    public static InfoBot _tracker;
    public int numEnemyBotsAlive = 1;
    public long initTicStartTime = 0L;
    public Point2D.Double myCoord;
    public Point2D.Double BattleField;
    double absurdly_huge = 1000000.0;
    double desiredBodyRotationDirection = 0.0;
    private String logFileName = "EvBot.log";
    public int verbosity_level = 5;
    private static RobocodeFileWriter fileWriter;
    private boolean appendToLogFlag = false;
    public logger _log = null;

    public void initBattle() {
        if (fileWriter == null) {
            try {
                fileWriter = new RobocodeFileWriter(this.getDataFile(this.logFileName));
                this._log = new logger(this.verbosity_level, fileWriter);
            }
            catch (IOException iOException) {
                System.out.println("Trouble opening the logging file: " + iOException.getMessage());
                this._log = new logger(this.verbosity_level);
            }
        }
        this.roundCnt = this.getRoundNum() + 1;
        logger.routine("=========== Round #" + this.roundCnt + "=============");
        this.BattleField = new Point2D.Double(this.getBattleFieldWidth(), this.getBattleFieldHeight());
        physics.init(this);
        math.init(this);
        this.myCoord = new Point2D.Double(this.getX(), this.getY());
        this.setColors(Color.red, Color.blue, Color.green);
        this.botVer = new botVersion();
        this.totalNumOfEnemiesAtStart = this.getOthers();
        if (finishingPlacesStats == null) {
            finishingPlacesStats = new int[this.totalNumOfEnemiesAtStart + 1];
        }
        if (skippedTurnStats == null) {
            skippedTurnStats = new int[this.getNumRounds()];
        }
        this._trgt = new target();
        this._radar = new radar(this);
        this._motion = new dangerMapMotion(this);
        this._bmanager = new bulletsManager(this);
        this._gmanager = new gunManager(this);
        this._gun = this._gmanager.getDefaultGun();
        this._botsmanager = new botsManager(this);
        if (_tracker == null) {
            _tracker = new InfoBot(this.getName());
        }
        this.initTicStartTime = System.nanoTime();
    }

    public void initTic() {
        long l = System.nanoTime();
        this.numEnemyBotsAlive = this.getOthers();
        this.setAdjustRadarForRobotTurn(true);
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.ticTime = this.getTime();
        logger.noise("----------- Bot version: " + this.botVer.getVersion() + "------- Tic # " + this.ticTime + " -------------");
        logger.profiler("===> time between initTics =        \t\t\t" + (l - this.initTicStartTime) + " ns");
        this.initTicStartTime = l;
        logger.noise("Game time: " + this.ticTime);
        logger.noise("Number of other bots = " + this.numEnemyBotsAlive);
        if (this.numEnemyBotsAlive == 0) {
            return;
        }
        this.myCoord.x = this.getX();
        this.myCoord.y = this.getY();
        l = System.nanoTime();
        _tracker.update(new botStatPoint(this));
        long l2 = System.nanoTime();
        logger.profiler("tracker update execution time =     \t\t\t" + (l2 - l) + " ns");
        l = System.nanoTime();
        this._botsmanager.initTic(this.ticTime);
        l2 = System.nanoTime();
        logger.profiler("botsmanager initTic execution time =\t\t\t" + (l2 - l) + " ns");
        l = System.nanoTime();
        this._trgt.initTic(this.ticTime);
        l2 = System.nanoTime();
        logger.profiler("target initTic execution time =        \t\t\t" + (l2 - l) + " ns");
        l = System.nanoTime();
        this._bmanager.initTic();
        l2 = System.nanoTime();
        logger.profiler("bullet manager initTic execution time =\t\t\t" + (l2 - l) + " ns");
        l = System.nanoTime();
        this._motion.initTic();
        l2 = System.nanoTime();
        logger.profiler("motion manager initTic execution time =\t\t\t" + (l2 - l) + " ns");
        l = System.nanoTime();
        this._gun.initTic();
        if (this._gun.getNumTicsInColdState() > 1) {
            ++numTicsWhenGunInColdState;
        }
        l2 = System.nanoTime();
        logger.profiler("gun init Tic execution time  =          \t\t\t" + (l2 - l) + " ns");
        l = System.nanoTime();
        this._radar.initTic();
        l2 = System.nanoTime();
        logger.profiler("radar init Tic execution time =         \t\t\t" + (l2 - l) + " ns");
    }

    public long getTime() {
        return super.getTime() + (long)(100000 * (this.getRoundNum() + 1));
    }

    public String fightType() {
        double d = 1.0 * (double)this.numEnemyBotsAlive / (double)this.totalNumOfEnemiesAtStart;
        if (this.numEnemyBotsAlive == 1 && this.totalNumOfEnemiesAtStart == 1) {
            return "1on1";
        }
        if (this.numEnemyBotsAlive == 1 && this.totalNumOfEnemiesAtStart != 1) {
            return "melee1on1";
        }
        if (d > 0.6666666666666666) {
            return "melee";
        }
        return "meleeMidle";
    }

    public double distTo(double d, double d2) {
        double d3 = d - this.myCoord.x;
        double d4 = d2 - this.myCoord.y;
        return Math.sqrt(d3 * d3 + d4 * d4);
    }

    public boolean isBotMovingClockWiseWithRespectToPoint(double d, double d2) {
        double d3;
        double d4;
        double d5 = this.myCoord.x;
        double d6 = this.myCoord.y;
        double d7 = this.getHeadingRadians();
        double d8 = this.getVelocity() * Math.sin(d7);
        double d9 = d5 - d;
        double d10 = this.getVelocity() * Math.cos(d7);
        double d11 = d6 + d10 - d2;
        double d12 = d9 * d11 - (d4 = d6 - d2) * (d3 = d5 + d8 - d);
        return !(d12 >= 0.0);
    }

    public void choseMotion() {
        boolean bl = false;
        if (bl) {
            this._motion = new dangerMapMotion(this);
        }
    }

    public void run() {
        this.initBattle();
        while (true) {
            long l = System.nanoTime();
            this.initTic();
            if (this.numEnemyBotsAlive == 0) {
                this.setAhead(0.0);
                this.setStop();
                this.execute();
                continue;
            }
            this._trgt = this._botsmanager.choseTarget();
            if (this._trgt.haveTarget) {
                this._gun = this._gmanager.choseGun();
            }
            this.choseMotion();
            long l2 = System.nanoTime();
            this._motion.makeMove();
            long l3 = System.nanoTime();
            logger.profiler("makeMove execution time     =\t\t\t\t" + (l3 - l2) + " ns");
            l2 = System.nanoTime();
            this._gun.manage();
            l3 = System.nanoTime();
            logger.profiler("gun manage execution time   =\t\t\t\t" + (l3 - l2) + " ns");
            l2 = System.nanoTime();
            this._radar.setNeedToTrackTarget(this._gun.doesItNeedTrackedTarget());
            this._radar.manage();
            l3 = System.nanoTime();
            logger.profiler("radar manage execution time =\t\t\t\t" + (l3 - l2) + " ns");
            l3 = System.nanoTime();
            logger.profiler("Main loop execution time =\t\t\t\t" + (l3 - l) + " ns");
            this.execute();
        }
    }

    public double angle2target() {
        return math.angle2pt(this.myCoord, this._trgt.getPosition());
    }

    public void onScannedRobot(ScannedRobotEvent scannedRobotEvent) {
        long l = System.nanoTime();
        this.myCoord.x = this.getX();
        this.myCoord.y = this.getY();
        this._botsmanager.onScannedRobot(scannedRobotEvent);
        this._radar.onScannedRobot(scannedRobotEvent);
        long l2 = System.nanoTime();
        logger.profiler("EvBot.onScannedRobot execution time =\t\t\t\t" + (l2 - l) + " ns");
    }

    public void onHitByBullet(HitByBulletEvent hitByBulletEvent) {
        this._botsmanager.onHitByBullet(hitByBulletEvent);
    }

    public void onBulletHit(BulletHitEvent bulletHitEvent) {
        LinkedList<baseGun> linkedList = null;
        logger.noise("Yey, we hit someone already " + ++bulletHitCnt);
        Bullet bullet = bulletHitEvent.getBullet();
        if (bullet == null) {
            logger.dbg("Weird, our hit bullet is not known to event");
            return;
        }
        logger.noise("event bullet " + bullet);
        logger.noise("Bullet activity status is " + bullet.isActive());
        if (bullet == null) {
            logger.dbg("Weird, hit bullet does not exists");
            return;
        }
        linkedList = this._bmanager.whichOfMyGunsFiredBullet(bullet);
        if (linkedList.size() == 0) {
            logger.dbg("Weird, hit bullet does not known its gun");
            return;
        }
        for (baseGun baseGun2 : linkedList) {
            logger.noise("This gun " + baseGun2.getName() + " was fired " + baseGun2.getBulletVirtFiredCount() + " times");
        }
    }

    public void onBulletMissed(BulletMissedEvent bulletMissedEvent) {
        Object var2_2 = null;
    }

    public void onRobotDeath(RobotDeathEvent robotDeathEvent) {
        if (robotDeathEvent.getName().equals(this._trgt.getName())) {
            this._trgt = new target();
        }
        this._botsmanager.onRobotDeath(robotDeathEvent);
        this._radar.onRobotDeath(robotDeathEvent);
    }

    public void onHitWall(HitWallEvent hitWallEvent) {
        double d = _tracker.getLast().getEnergy() - this.getEnergy();
        logger.dbg("FIXME SLOPPY PROGRAMMING: robot hit a wall with energy drop = " + d);
    }

    public double setBodyRotationDirection(double d) {
        this.desiredBodyRotationDirection = d;
        return this.desiredBodyRotationDirection;
    }

    public void onSkippedTurn(SkippedTurnEvent skippedTurnEvent) {
        int n = this.getRoundNum();
        skippedTurnStats[n] = skippedTurnStats[n] + 1;
    }

    public void onPaint(Graphics2D graphics2D) {
        if (this._trgt.haveTarget) {
            logger.noise("Gun choice = " + this._gun.getName());
            this._gun.onPaint(graphics2D);
        }
        logger.noise("targetUnlocked = " + this._trgt.targetUnlocked);
        if (this._trgt.haveTarget && this._trgt.targetUnlocked) {
            graphics2D.setColor(Color.yellow);
            graphics2D.drawOval((int)(this.myCoord.x - 50.0), (int)(this.myCoord.y - 50.0), 100, 100);
        }
        if (this._trgt.haveTarget && !this._trgt.targetUnlocked) {
            graphics2D.setColor(Color.red);
            graphics2D.drawOval((int)(this.myCoord.x - 50.0), (int)(this.myCoord.y - 50.0), 100, 100);
        }
        this._motion.onPaint(graphics2D);
        this._bmanager.onPaint(graphics2D);
        this._botsmanager.onPaint(graphics2D);
    }

    public void onWin(WinEvent winEvent) {
        ++roundsWon;
        this.updateFinishingPlacesStats();
        this.winOrLoseRoundEnd();
    }

    public void onDeath(DeathEvent deathEvent) {
        ++roundsLost;
        this.updateFinishingPlacesStats();
        this.winOrLoseRoundEnd();
    }

    public void onRoundEnded(RoundEndedEvent roundEndedEvent) {
    }

    public void updateFinishingPlacesStats() {
        int n;
        int n2 = n = this.getOthers();
        finishingPlacesStats[n2] = finishingPlacesStats[n2] + 1;
    }

    public void winOrLoseRoundEnd() {
        this._gmanager.printGunsStats();
        this._botsmanager.printGunsStats();
        logger.routine("Rounds ratio of win/lose = " + roundsWon + "/" + roundsLost);
        logger.routine("Skipped turns stats: " + Arrays.toString(skippedTurnStats));
        logger.routine("The gun was cold " + numTicsWhenGunInColdState + " tics");
        logger.routine("Finishing places stats: " + Arrays.toString(finishingPlacesStats));
    }

    public baseGun getGun() {
        return this._gun;
    }

    static {
        fileWriter = null;
    }
}

