/*
 * Decompiled with CFR 0.152.
 */
package EFD;

import EFD.AdvancedEFD;
import EFD.EFDUtils;
import EFD.TurnAngle;
import java.awt.geom.Point2D;
import robocode.util.Utils;

public class CircularMovement {
    static final boolean PAINT_ORBIT = false;
    static final boolean PAINT_HEADING = false;
    private AdvancedEFD r;

    public CircularMovement(AdvancedEFD r) {
        this.r = r;
    }

    public double getOrbitAngle(Point2D.Double currentPosition, Point2D.Double center, double radius, int direction) {
        double turnAngle = 0.0;
        double distanceToCenter = currentPosition.distance(center);
        double centerAngle = EFDUtils.absoluteAngle(currentPosition, center);
        if (distanceToCenter <= radius) {
            double correctiveFactor = 1.0 + (radius - distanceToCenter) / 300.0;
            turnAngle = Utils.normalAbsoluteAngle((double)(centerAngle + (double)direction * 1.5707963267948966 * correctiveFactor));
        } else {
            double relativeTurnAngle = Math.asin(radius / distanceToCenter);
            turnAngle = centerAngle + (double)direction * relativeTurnAngle;
        }
        Point2D.Double projected = EFDUtils.projectPoint(currentPosition, turnAngle, 150.0);
        if (projected.x < 18.0 || projected.x > this.r.getBattleFieldWidth() - 18.0 || projected.y < 18.0 || projected.y > this.r.getBattleFieldHeight() - 18.0) {
            if (projected.y > this.r.getBattleFieldHeight() - 18.0) {
                turnAngle = Math.acos((this.r.getBattleFieldHeight() - 18.0 - currentPosition.y) / 150.0);
                if (direction > 0) {
                    turnAngle = Math.PI * 2 - turnAngle;
                }
            }
            if (projected.x > this.r.getBattleFieldWidth() - 18.0) {
                turnAngle = (double)(-direction) * Math.acos((this.r.getBattleFieldWidth() - 18.0 - currentPosition.x) / 150.0) + 1.5707963267948966;
            }
            if (projected.y < 18.0) {
                turnAngle = (double)(-direction) * Math.acos((currentPosition.y - 18.0) / 150.0) + Math.PI;
            }
            if (projected.x < 18.0) {
                turnAngle = 4.71238898038469 - (double)direction * Math.acos((currentPosition.x - 18.0) / 150.0);
            }
        }
        return turnAngle;
    }

    public void move(Point2D.Double currentPosition, Point2D.Double center, double radius, int direction, int speed) {
        double angle = this.getOrbitAngle(currentPosition, center, radius, direction);
        TurnAngle turnAngle = EFDUtils.turnToAngle(angle, this.r.getHeadingRadians());
        if (turnAngle.direction > 0) {
            this.r.setTurnLeftRadians(turnAngle.turnAngle);
        } else {
            this.r.setTurnRightRadians(turnAngle.turnAngle);
        }
        if (turnAngle.reverse) {
            this.r.setBack(speed);
        } else {
            this.r.setAhead(speed);
        }
    }

    public double square(double x) {
        return x * x;
    }
}

