/*
 * Decompiled with CFR 0.152.
 */
package apollokidd;

import apollokidd.ApolloKidd;
import apollokidd.Enemy;
import apollokidd.Manager;
import apollokidd.Utility;
import java.util.Random;
import robocode.Bullet;
import robocode.Robot;

class OneVsOne
implements Manager {
    private static final double DELTA = 1.0471975511965976;
    ApolloKidd robot;
    Enemy target;
    Random random = new Random();
    int direction = 1;
    double firePower = 0.0;

    public void botMovement() {
        if (this.robot.getTime() % 20L == 0L) {
            double velocity = this.random.nextDouble() * 8.0 + 4.0;
            if (velocity < 4.0) {
                velocity = 4.0;
            }
            this.robot.setMaxVelocity(velocity);
            this.direction *= -1;
            this.robot.setAhead(this.direction * 300);
        }
        this.robot.setTurnRightRadians(this.target.getBearing() + 1.5707963267948966 - (double)this.direction * 1.0471975511965976);
    }

    public void bulletPower() {
        this.firePower = -Math.log(this.target.getDistance() / Utility.arenaDiagonal((Robot)this.robot));
    }

    public void scanningArena() {
        double radarOffset;
        if (this.robot.getTime() - this.target.getTime() > 4L) {
            double d = 360.0;
        } else {
            radarOffset = this.robot.getRadarHeadingRadians() - Utility.absbearing(this.robot.getX(), this.robot.getY(), this.target.getX(), this.target.getY());
            radarOffset = radarOffset < 0.0 ? (radarOffset -= Math.PI / 90) : (radarOffset += Math.PI / 90);
        }
        this.robot.setTurnRadarLeftRadians(Utility.NormaliseBearing(radarOffset));
    }

    public void setGun() {
        long time = this.robot.getTime() + (long)((int)(this.target.getDistance() / (20.0 - 3.0 * this.firePower)));
        double gunOffset = this.robot.getGunHeadingRadians() - Utility.absbearing(this.robot.getX(), this.robot.getY(), this.target.guessX(time), this.target.guessY(time));
        this.robot.setTurnGunLeftRadians(Utility.NormaliseBearing(gunOffset));
    }

    public Bullet bulletFire() {
        return this.robot.fireBullet(this.firePower);
    }

    public void tooClose() {
    }

    OneVsOne(ApolloKidd myBot) {
        this.robot = myBot;
        this.target = myBot.getTarget();
    }
}

