/*
 * Decompiled with CFR 0.152.
 */
package gjr;

import gjr.AntigravityMovementStrategy;
import gjr.CircularTargetingStrategy;
import gjr.Enemy;
import gjr.RobocodeUtils;
import gjr.StrategyRobot;
import java.awt.Color;
import java.awt.geom.Point2D;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.WinEvent;

public final class Cephalosporin
extends StrategyRobot {
    private static long misses = 0L;
    private static long hits = 0L;

    public void run() {
        this.setColors(Color.red, Color.white, Color.blue);
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
        this.enemies.put("Center Field", new Enemy("Center Field", this.getBattleFieldWidth() / 2.0, this.getBattleFieldHeight() / 2.0));
        this.setMovementStrategy(new AntigravityMovementStrategy());
        this.setTargetingStrategy(new CircularTargetingStrategy());
        while (true) {
            this.movementStrategy.doMovement(this);
            this.doScanner();
            this.targetingStrategy.doTargetting(this);
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        String name = e.getName();
        double absoluteBearing = e.getBearingRadians() + this.getHeadingRadians();
        double distance = e.getDistance();
        Point2D.Double myPosition = new Point2D.Double(this.getX(), this.getY());
        Point2D.Double enemyPosition = RobocodeUtils.calculatePosition(absoluteBearing, distance, myPosition);
        double enemyHeadingRadians = e.getHeadingRadians();
        double enemyVelocity = e.getVelocity();
        double enemyEnergy = e.getEnergy();
        long time = this.getTime();
        Object enemyObject = this.enemies.get(name);
        if (enemyObject != null) {
            Enemy enemy = (Enemy)enemyObject;
            enemy.setX(enemyPosition.getX());
            enemy.setY(enemyPosition.getY());
            enemy.setHeadingRadiansChange((enemyHeadingRadians - enemy.getHeadingRadians()) / (double)(time - enemy.getTime()));
            enemy.setHeadingRadians(enemyHeadingRadians);
            enemy.setAcceleration((enemyVelocity - enemy.getVelocity()) / (double)(time - enemy.getTime()));
            enemy.setVelocity(enemyVelocity);
            enemy.setEnergy(enemyEnergy);
            enemy.setTime(time);
        } else {
            Enemy enemy = new Enemy(name, enemyPosition.getX(), enemyPosition.getY(), enemyHeadingRadians, enemyVelocity, enemyEnergy, time, true, 1.0);
            this.enemies.put(e.getName(), enemy);
        }
    }

    public void onRobotDeath(RobotDeathEvent e) {
        this.enemies.remove(e.getName());
    }

    public void onHitByBullet(HitByBulletEvent e) {
        double power = e.getPower();
        double damage = RobocodeUtils.calculateBulletDamage(power);
        Object enemyObject = this.enemies.get(e.getName());
        if (enemyObject != null) {
            Enemy enemy = (Enemy)enemyObject;
            enemy.setDanger(enemy.getDanger() + damage);
        }
    }

    public void onBulletHit(BulletHitEvent e) {
        ++hits;
    }

    public void onBulletMissed(BulletMissedEvent e) {
        ++misses;
    }

    public void onWin(WinEvent e) {
        this.doGameOver();
    }

    public void onDeath(DeathEvent e) {
        this.doGameOver();
    }

    private void doTargetting() {
    }

    private void doScanner() {
        Enemy closest = this.getClosestEnemy();
        if (closest != null) {
            double radarOffset;
            radarOffset = this.getTime() - closest.getTime() > 4L ? Double.POSITIVE_INFINITY : ((radarOffset = this.getRadarHeadingRadians() - RobocodeUtils.absBearing(this.getX(), this.getY(), closest.getX(), closest.getY())) < 0.0 ? (radarOffset -= 0.39269908169872414) : (radarOffset += 0.39269908169872414));
            this.setTurnRadarLeftRadians(RobocodeUtils.normaliseBearing(radarOffset));
        }
    }

    private void doGameOver() {
        this.out.println("Game Over. Hits: " + hits + " Misses: " + misses);
    }
}

