/*
 * Decompiled with CFR 0.152.
 */
package wcsv.Coyote;

import java.awt.Color;
import java.io.IOException;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.TreeMap;
import robocode.MessageEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.TeamRobot;
import robocode.util.Utils;
import wcsv.Coyote.Point;

public class Coyote
extends TeamRobot {
    private static Point myLoc;
    private static Point allyLoc;
    private static TreeMap enemies;
    private static TreeMap neuralNets;
    private static Info target;
    private static boolean aimingGun;
    private static double bulletPower;
    private static double width;
    private static double height;
    private static final double[] normalVector;

    public void run() {
        this.setAdjustRadarForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.setAdjustGunForRobotTurn(true);
        this.setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
        this.setColors(Color.orange, Color.black, Color.black);
        width = this.getBattleFieldWidth();
        height = this.getBattleFieldHeight();
        enemies.clear();
        target = null;
        aimingGun = false;
        while (true) {
            myLoc = new Point(this.getX(), this.getY());
            if (aimingGun && Math.abs(this.getGunTurnRemainingRadians()) < 0.01) {
                boolean bl;
                if (allyLoc != null) {
                    bl = false;
                    if (Math.abs(Utils.normalRelativeAngle((double)(this.getGunHeadingRadians() - this.absoluteAngleToPoint(myLoc, allyLoc)))) > 0.125) {
                        bl = true;
                    }
                } else {
                    bl = true;
                }
                if (bl && this.setFireBullet(bulletPower) != null) {
                    aimingGun = false;
                }
            }
            if (this.getDistanceRemaining() < 15.0 || Math.random() < 0.08) {
                double lowestRisk;
                Info enemy;
                Object[] enemyList = enemies.values().toArray();
                double angle = 0.0;
                double bestAngle = 0.0;
                double risk = 0.0;
                int i = 0;
                while (i < enemyList.length) {
                    enemy = (Info)enemyList[i];
                    lowestRisk = enemy.energy / enemy.distance;
                    angle += enemy.loc.x * lowestRisk;
                    bestAngle += enemy.loc.y * lowestRisk;
                    risk += lowestRisk;
                    ++i;
                }
                angle = this.absoluteAngleToPoint(myLoc, new Point(angle / risk, bestAngle / risk)) - 1.58;
                lowestRisk = Double.MAX_VALUE;
                double a = -1.0;
                while (a <= 1.0) {
                    double b = 0.0;
                    while (b <= 3.14) {
                        Point dest = this.project(myLoc, angle + 0.5 * a - b, 130.0);
                        risk = 1.0 / Math.pow(this.wallDist(dest), 2.5);
                        int i2 = 0;
                        while (i2 < enemyList.length) {
                            enemy = (Info)enemyList[i2];
                            risk += enemy.energy / this.getEnergy() / this.sqr(this.distance(enemy.loc, dest));
                            ++i2;
                        }
                        if (allyLoc != null) {
                            risk += 1.0 / Math.pow(this.distance(allyLoc, dest), 1.7);
                        }
                        if (risk < lowestRisk) {
                            bestAngle = this.absoluteAngleToPoint(myLoc, dest);
                            lowestRisk = risk;
                        }
                        b += 3.14;
                    }
                    a += 0.2;
                }
                bestAngle = Utils.normalRelativeAngle((double)(bestAngle - this.getHeadingRadians()));
                angle = Math.atan(Math.tan(bestAngle));
                this.setTurnRightRadians(angle);
                this.setAhead(bestAngle == angle ? 130 : -130);
            }
            this.execute();
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        try {
            myLoc = new Point(this.getX(), this.getY());
            this.broadcastMessage(myLoc);
        }
        catch (IOException exception) {
            // empty catch block
        }
        if (!this.isTeammate(e.getName())) {
            Info scan = (Info)enemies.get(e.getName());
            if (scan == null) {
                scan = new Info();
                scan.waves = new LinkedList();
            }
            scan.name = e.getName();
            if (!neuralNets.containsKey(scan.name)) {
                neuralNets.put(scan.name, new Map());
            }
            scan.distance = e.getDistance();
            bulletPower = Math.max(Math.min(700.0 / scan.distance, (double)3), 0.1);
            scan.energy = e.getEnergy();
            scan.bearing = e.getBearingRadians() + this.getHeadingRadians();
            scan.loc = this.project(myLoc, scan.bearing, scan.distance);
            double[] dArray = new double[4];
            dArray[0] = Math.min(700.0, scan.distance);
            scan.heading = e.getHeadingRadians();
            dArray[1] = Math.sin(scan.heading - scan.bearing) * e.getVelocity();
            dArray[2] = -Math.cos(scan.heading - scan.bearing) * e.getVelocity();
            dArray[3] = bulletPower;
            double[] currentVector = dArray;
            scan.waves.addLast(new Wave(scan.bearing, dArray));
            if (target == null || scan.energy * scan.distance < Coyote.target.energy * Coyote.target.distance * 0.9) {
                target = scan;
            }
            if (scan.name.equals(Coyote.target.name)) {
                if (this.getGunHeat() > this.getGunCoolingRate()) {
                    this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(scan.bearing - this.getGunHeadingRadians())));
                    this.setTurnRadarLeftRadians(this.getRadarTurnRemainingRadians());
                    aimingGun = false;
                } else if (!aimingGun) {
                    this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(scan.bearing + Math.asin(8.0 / (20.0 - (double)3 * bulletPower)) * ((Map)neuralNets.get(scan.name)).get(currentVector) - this.getGunHeadingRadians())));
                    aimingGun = true;
                }
            }
            ListIterator it = scan.waves.listIterator();
            do {
                Wave w = (Wave)it.next();
                if (!(this.distance(w.center, scan.loc) - w.radius() < 18.0)) continue;
                ((Map)neuralNets.get(scan.name)).add(w.featureVector, Utils.normalRelativeAngle((double)(this.absoluteAngleToPoint(w.center, scan.loc) - w.startBearing)) / Math.asin(8.0 / w.velocity));
                it.remove();
            } while (it.hasNext());
            enemies.put(scan.name, scan);
        }
    }

    public void onMessageReceived(MessageEvent e) {
        allyLoc = (Point)e.getMessage();
    }

    public void onRobotDeath(RobotDeathEvent e) {
        enemies.remove(e.getName());
        if (this.isTeammate(e.getName())) {
            allyLoc = null;
        }
        if (target != null && e.getName().equals(Coyote.target.name)) {
            target = null;
        }
    }

    public double absoluteAngleToPoint(Point p1, Point p2) {
        return Utils.normalAbsoluteAngle((double)Math.atan2(p2.x - p1.x, p2.y - p1.y));
    }

    public double distance(Point p1, Point p2) {
        return Math.sqrt(this.sqr(p1.x - p2.x) + this.sqr(p1.y - p2.y));
    }

    public double sqr(double d) {
        return d * d;
    }

    public Point project(Point src, double angle, double dist) {
        return new Point(src.x + Math.sin(angle) * dist, src.y + Math.cos(angle) * dist);
    }

    public double wallDist(Point p) {
        return Math.min(Math.min(p.x, p.y), Math.min(width - p.x, height - p.y));
    }

    static {
        enemies = new TreeMap();
        neuralNets = new TreeMap();
        bulletPower = 1.75;
        normalVector = new double[]{490000.0, 256.0, 256.0, 9.0};
    }

    private class Info {
        Point loc;
        double heading;
        double bearing;
        double distance;
        double energy;
        String name;
        LinkedList waves;

        private Info() {
        }
    }

    private class Wave {
        Point center;
        double velocity;
        double startBearing;
        int startTime;
        double[] featureVector;

        public double radius() {
            return (double)(Coyote.this.getTime() - (long)this.startTime) * this.velocity;
        }

        public Wave(double bearing, double[] vect) {
            this.center = new Point(myLoc.x, myLoc.y);
            this.velocity = 20.0 - (double)3 * bulletPower;
            this.startTime = (int)Coyote.this.getTime();
            this.startBearing = bearing;
            this.featureVector = vect;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class Map {
        public Node head;

        public void add(double[] v, double gf) {
            double d;
            Node closest = this.closestNode(v);
            Node toAdd = new Node();
            toAdd.featureVector = v;
            if (closest == null || this.distance(closest.featureVector, v) > 0.27) {
                toAdd.next = this.head;
                this.head = toAdd;
                closest = toAdd;
            } else {
                this.combine(toAdd.featureVector, closest);
            }
            ++closest.uses;
            double d2 = -1.05;
            while (!(gf <= d) && (d2 += 0.05) < 1.0) {
            }
            int n = (int)((d2 + 1.0) / 0.05);
            closest.buffer[n] = closest.buffer[n] + 1.0;
        }

        public double get(double[] v) {
            Node closest = this.closestNode(v);
            int max = 20;
            if (closest != null) {
                int i = 0;
                while (i < closest.buffer.length) {
                    if (closest.buffer[i] > closest.buffer[max]) {
                        max = i;
                    }
                    ++i;
                }
            }
            return (double)max * 0.05 - 1.0;
        }

        public Node closestNode(double[] vector) {
            Node temp = this.head;
            Node closest = null;
            double closestDist = Double.MAX_VALUE;
            while (temp != null) {
                double currDist = this.distance(temp.featureVector, vector);
                if (currDist < closestDist) {
                    closestDist = currDist;
                    closest = temp;
                }
                temp = temp.next;
            }
            return closest;
        }

        public double distance(double[] v1, double[] v2) {
            double dist = 0.0;
            int i = 0;
            while (i < v1.length) {
                dist += Coyote.this.sqr(v1[i] - v2[i]) / normalVector[i];
                ++i;
            }
            return Math.sqrt(dist);
        }

        public void combine(double[] input, Node vector) {
            int i = 0;
            while (i < input.length) {
                vector.featureVector[i] = (vector.featureVector[i] * (double)vector.uses + input[i]) / ((double)vector.uses + 1.0);
                ++i;
            }
        }

        private final /* synthetic */ void this() {
            this.head = null;
        }

        private Map() {
            this.this();
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        public class Node {
            int uses;
            Node next;
            Node prev;
            double[] featureVector;
            double[] buffer;

            private final /* synthetic */ void this() {
                this.uses = 0;
                this.buffer = new double[41];
            }

            public Node() {
                this.this();
            }
        }
    }
}

