/*
 * Decompiled with CFR 0.152.
 */
package catcat20.gun;

import catcat20.gun.pif.PlayItForward;
import catcat20.radar.Radar;
import catcat20.utils.LConstants;
import catcat20.utils.LUtils;
import catcat20.utils.ShadowBullet;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import robocode.Bullet;
import robocode.BulletHitEvent;
import robocode.Rules;
import robocode.TeamRobot;
import robocode.util.Utils;

public class LambdaGun {
    public TeamRobot _robot;
    public static PlayItForward meleeGun;
    public static ArrayList<ShadowBullet> realBullets;
    public double duelLostPower = 0.0;
    public double duelGetPower = 0.0;
    public double meleeLostPower = 0.0;
    public double meleeGetPower = 0.0;

    public LambdaGun(TeamRobot _robot) {
        this._robot = _robot;
        meleeGun = new PlayItForward(_robot);
    }

    public void init() {
        realBullets = new ArrayList();
        this.duelLostPower = 0.0;
        this.duelGetPower = 0.0;
        this.meleeLostPower = 0.0;
        this.meleeGetPower = 0.0;
        meleeGun.init();
    }

    public void onTick() {
        double epsilon;
        double angle;
        int others = this._robot.getOthers();
        Point2D.Double myPos = new Point2D.Double(this._robot.getX(), this._robot.getY());
        meleeGun.execute();
        double firePower = Radar.getFirePower();
        boolean doTurnGun = false;
        if (this._robot.getGunHeat() <= LConstants.GUN_COOLING_RATE * 3.0) {
            doTurnGun = true;
        } else if (Radar.nearestBot != null && Radar.nearestBot.isAlive && Radar.nearestBot.currentState != null && others <= 1 && Radar.nearestBot.currentState.distance(myPos.x, myPos.y) <= 250.0) {
            doTurnGun = true;
        }
        if (doTurnGun) {
            angle = meleeGun.getAngle(firePower);
            epsilon = Utils.getRandom().nextDouble(-1.0E-12, 1.0E-12);
            this._robot.setTurnGunRightRadians(Utils.normalRelativeAngle((double)((angle += epsilon) - this._robot.getGunHeadingRadians())));
        } else if (Radar.nearestBot != null && Radar.nearestBot.isAlive && Radar.nearestBot.currentState != null && (others <= 1 || !(Radar.nearestBot.currentState.distance(myPos.x, myPos.y) > 100.0)) && others <= 1) {
            angle = LUtils.absoluteBearing(myPos.x, myPos.y, Radar.nearestBot.currentState.x, Radar.nearestBot.currentState.y);
            epsilon = Utils.getRandom().nextDouble(-1.0E-12, 1.0E-12);
            this._robot.setTurnGunRightRadians(Utils.normalRelativeAngle((double)((angle += epsilon) - this._robot.getGunHeadingRadians())));
        }
        if (Radar.nearestBot != null && Radar.nearestBot.isAlive && Radar.nearestBot.currentState != null && others <= 1 && Radar.nearestBot.currentState.distance(myPos.x, myPos.y) <= 80.0) {
            angle = LUtils.absoluteBearing(myPos.x, myPos.y, Radar.nearestBot.currentState.x, Radar.nearestBot.currentState.y);
            epsilon = Utils.getRandom().nextDouble(-1.0E-12, 1.0E-12);
            this._robot.setTurnGunRightRadians(Utils.normalRelativeAngle((double)((angle += epsilon) - this._robot.getGunHeadingRadians())));
        }
        Bullet bullet = null;
        if (doTurnGun && this._robot.getGunTurnRemaining() < 1.0) {
            if (this._robot.getEnergy() > firePower + 0.15 || LConstants.TC_MODE) {
                bullet = this._robot.setFireBullet(firePower);
            }
        } else if (!(Radar.nearestBot != null && Radar.nearestBot.isAlive && Radar.nearestBot.currentState != null && others <= 1 && Radar.nearestBot.currentState.distance(myPos.x, myPos.y) <= 100.0 && this._robot.getEnergy() > firePower + 0.15 && (bullet = this._robot.setFireBullet(firePower)) == null)) {
            // empty if block
        }
        if (bullet != null) {
            if (others <= 1 && Radar.nearestBot != null) {
                ++Radar.nearestBot.shotsFiredDuel;
            }
            realBullets.add(new ShadowBullet(bullet.getX(), bullet.getY(), this._robot.getTime(), bullet.getVelocity(), bullet.getHeadingRadians()));
            if (others <= 1) {
                this.duelLostPower += bullet.getPower();
            } else {
                this.meleeLostPower += bullet.getPower();
            }
        }
    }

    public void endTask() {
        System.out.println();
        System.out.println("duel lost: " + this.duelLostPower);
        System.out.println("duel get: " + this.duelGetPower);
        System.out.println();
        System.out.println("melee lost: " + this.meleeLostPower);
        System.out.println("melee get: " + this.meleeGetPower);
        System.out.println();
    }

    public void onBulletHit(BulletHitEvent e) {
        if (this._robot.getOthers() <= 1) {
            this.duelGetPower += Rules.getBulletHitBonus((double)e.getBullet().getPower());
        } else {
            this.meleeGetPower += Rules.getBulletHitBonus((double)e.getBullet().getPower());
        }
    }

    public void onPaint(Graphics2D g) {
        meleeGun.onPaint(g);
    }
}

