/*
 * Decompiled with CFR 0.152.
 */
package jbot;

import java.awt.Graphics2D;
import jbot.Rabbit2;
import jbot.engines.Engine;
import jbot.engines.MainEngine;
import jbot.guns.Gun;
import jbot.guns.MainGun;
import jbot.tracer.Target;
import jbot.tracer.Tracer;
import robocode.HitByBulletEvent;
import robocode.ScannedRobotEvent;

public class Strategy {
    private boolean mIsSetup = false;
    protected Rabbit2 mBot;
    protected Engine mEngine;
    protected Gun mGun;
    protected Tracer mTracer;
    protected Target mSelf;
    protected Target mTarget;

    public Engine getCurrentEngine() {
        return this.mEngine;
    }

    public Gun getCurrentGun() {
        return this.mGun;
    }

    public Strategy(Rabbit2 bot) {
        this.mBot = bot;
        this.mEngine = new MainEngine(this.mBot);
        this.mGun = new MainGun(this.mBot);
        this.mTracer = this.mBot.getTracer();
        this.mTarget = this.mTracer.getEnemyTarget();
        this.mSelf = this.mTracer.getSelfTarget();
    }

    public boolean setup() {
        if (this.mIsSetup) {
            return false;
        }
        this.mIsSetup = true;
        return true;
    }

    protected void frameLogic(double deltaTime) {
        if (this.mTracer.isSetup()) {
            this.mGun.permitEnergy(true);
            double wallsFactor = this.mTracer.mWallsGravityTechnique.getWallsInteractionFactor();
            this.mTracer.mWallsGravityTechnique.setEfficient(wallsFactor);
            this.mTracer.mSegmentedAngleTechnique.setEfficient(1.0 - wallsFactor / 2.0);
            this.mTracer.mMultiAvgTechnique.setEfficient(1.0 - wallsFactor / 2.0);
            this.mTracer.mSmoothVelocityTechnique.setEfficient(1.0 - wallsFactor / 2.0);
        }
    }

    public void frame(double deltaTime) {
        this.frameLogic(deltaTime);
        this.mEngine.frame(deltaTime);
        this.mGun.frame(deltaTime);
    }

    public void onScannedTarget(double deltaTime, ScannedRobotEvent evt) {
    }

    public void onHitByBullet(HitByBulletEvent evt) {
        this.mEngine.onHitByBullet(evt);
    }

    public void onPaint(Graphics2D g) {
        this.mGun.onPaint(g);
        this.mEngine.onPaint(g);
    }
}

