/*
 * Decompiled with CFR 0.152.
 */
package satan;

import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import robocode.AdvancedRobot;
import robocode.BulletHitEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.Rules;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;

public final class White
extends AdvancedRobot {
    static final Rectangle2D.Double MOVEAREA = new Rectangle2D.Double(18.0, 18.0, 764.0, 564.0);
    static double enemyEnergy = 100.0;
    static double direction = 1.0;
    static double TURN_DIRECTION = 0.2;
    static final int GUN_BINS = 230;
    static final int MAX_MATCHES = 50;
    static StringBuilder data = new StringBuilder();

    public void run() {
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.setAllColors(Color.WHITE);
        while (true) {
            this.turnRadarRightRadians(Double.POSITIVE_INFINITY);
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        double headingRadians = this.getHeadingRadians();
        double absBearing = e.getBearingRadians() + headingRadians;
        double distance = e.getDistance();
        boolean rammer = distance < 150.0;
        double d = enemyEnergy;
        enemyEnergy = e.getEnergy();
        double offset = d - enemyEnergy;
        if (rammer || offset > 0.0 && offset <= 3.0) {
            if (!rammer && Math.random() < TURN_DIRECTION) {
                direction = -direction;
            }
            offset = direction * 160.0;
            if (!MOVEAREA.contains(this.getX() + offset * Math.sin(headingRadians), this.getY() + offset * Math.cos(headingRadians))) {
                direction = -direction;
            }
            offset = direction * (distance / 4.0 * Math.random() + 60.0);
            this.setAhead(offset);
        }
        if (rammer) {
            this.setTurnRight(e.getBearing() + 90.0 + direction * 10.0);
        } else {
            this.setTurnRight(e.getBearing() + 90.0 + direction * -10.0);
        }
        double bulletPower = rammer ? 2.99 : Math.min(2.49, Math.min(enemyEnergy / 4.0, this.getEnergy() / 10.0));
        this.setFire(bulletPower);
        data.insert(0, (char)((int)Math.round(e.getVelocity() * Math.sin(headingRadians)) << 8 | 0xFF & (byte)(e.getVelocity() * Math.cos(headingRadians))));
        int keyLength = Math.min(66, data.length());
        int indexSize = 0;
        int tempIndex = 0;
        int[] index = new int[50];
        int[] bins = new int[230];
        while (true) {
            char comboChar;
            if (tempIndex < 0) {
                keyLength = keyLength * 3 / 4;
            }
            if (((tempIndex = data.indexOf(data.substring(0, keyLength), tempIndex + 2)) < 0 || Arrays.binarySearch(index, tempIndex) >= 0) && keyLength > 0) continue;
            if (keyLength == 0) break;
            int iterateIndex = index[0] = tempIndex;
            Arrays.sort(index);
            double tempDist = distance;
            double tmpBearing = 0.0;
            double db = 0.0;
            do {
                comboChar = data.charAt(iterateIndex--);
                tmpBearing += (double)((byte)(comboChar >> 8)) / tempDist;
            } while ((db += Rules.getBulletSpeed((double)bulletPower)) < (tempDist += (double)((byte)(comboChar & 0xFF))) && iterateIndex > 0);
            int n = (int)(Utils.normalAbsoluteAngle((double)tmpBearing) * 36.44648196804403);
            bins[n] = bins[n] + keyLength;
            if (++indexSize >= 50) break;
        }
        keyLength = 229;
        tempIndex = 0;
        do {
            if (bins[keyLength] <= bins[tempIndex]) continue;
            tempIndex = keyLength;
        } while (keyLength-- > 0);
        double gunAngle = (double)tempIndex * 0.027437490424365007;
        this.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(absBearing + 0.005 + gunAngle - this.getGunHeadingRadians())));
        this.setTurnRadarRightRadians(Utils.normalRelativeAngle((double)(absBearing - this.getRadarHeadingRadians())) * 2.0);
    }

    public void onHitByBullet(HitByBulletEvent e) {
        enemyEnergy += 20.0 - e.getVelocity();
    }

    public void onBulletHit(BulletHitEvent e) {
        enemyEnergy -= Rules.getBulletDamage((double)e.getBullet().getPower());
    }

    public void onDeath(DeathEvent e) {
        TURN_DIRECTION = TURN_DIRECTION == 0.2 ? 0.4 : 0.2;
    }
}

