/*
 * Decompiled with CFR 0.152.
 */
package pedersen.physics;

import pedersen.physics.Direction;
import pedersen.physics.Energy;
import pedersen.physics.HasVehicle;
import pedersen.physics.Position;
import pedersen.physics.Snapshot;
import pedersen.physics.Vector;
import pedersen.physics.Vehicle;
import pedersen.physics.Velocity;
import pedersen.physics.VelocityVector;
import pedersen.physics.constant.EnergyImpl;
import pedersen.physics.constant.VehicleImpl;
import pedersen.physics.constant.VelocityVectorImpl;

public class SnapshotImpl
implements Snapshot {
    private final Vehicle vehicle;
    private final int round;
    private final long time;
    private final Energy energy;
    private Snapshot pPrevious = null;
    private VelocityVector deltaVector = null;
    public static long counter = 0L;
    public static long release = 0L;

    public SnapshotImpl(int round, long time, HasVehicle chassis, double e) {
        this.round = round;
        this.time = time;
        this.vehicle = chassis.getVehicle();
        this.energy = new EnergyImpl(e);
        this.pPrevious = this;
        ++counter;
    }

    public SnapshotImpl(int round, long time, double x, double y, double r, double v, double e) {
        this(round, time, new VehicleImpl(x, y, r, v), e);
    }

    @Override
    public Snapshot getSnapshot() {
        return this;
    }

    @Override
    public Vehicle getVehicle() {
        return this.vehicle;
    }

    @Override
    public Energy getEnergy() {
        return this.energy;
    }

    @Override
    public Position getPosition() {
        return this.vehicle.getPosition();
    }

    @Override
    public VelocityVector getVelocityVector() {
        return this.vehicle.getVelocityVector();
    }

    @Override
    public Vector getVector() {
        return this.vehicle.getVector();
    }

    @Override
    public Direction getDirection() {
        return this.vehicle.getDirection();
    }

    @Override
    public Velocity getVelocity() {
        return this.vehicle.getVelocity();
    }

    @Override
    public int getRound() {
        return this.round;
    }

    @Override
    public long getTime() {
        return this.time;
    }

    @Override
    public void setPrevious(Snapshot other) {
        this.pPrevious = other;
    }

    @Override
    public Snapshot getPrevious() {
        return this.pPrevious;
    }

    @Override
    public void breakLinks() {
        if (this.pPrevious != null && this.pPrevious != this) {
            this.pPrevious.breakLinks();
            ++release;
            this.pPrevious = null;
        }
    }

    @Override
    public VelocityVector getDeltaVector() {
        if (this.deltaVector == null) {
            double deltaHeading = this.getVehicle().getDirection().getAbsoluteRadians() - this.pPrevious.getVehicle().getDirection().getAbsoluteRadians();
            double deltaVelocity = this.getVehicle().getVelocity().velocity() - this.pPrevious.getVehicle().getVelocity().velocity();
            this.deltaVector = new VelocityVectorImpl(deltaHeading, deltaVelocity);
        }
        return this.deltaVector;
    }

    @Override
    public Direction getDeltaHeading() {
        return this.getDeltaVector().getDirection();
    }

    @Override
    public Velocity getDeltaVelocity() {
        return this.getDeltaVector().getVelocity();
    }
}

