/*
 * Decompiled with CFR 0.152.
 */
package pedersen.physics.constant;

import pedersen.debug.DebuggableBase;
import pedersen.physics.Direction;
import pedersen.physics.HasDirection;
import pedersen.physics.HasVector;
import pedersen.physics.HasVelocity;
import pedersen.physics.HasVelocityVector;
import pedersen.physics.Magnitude;
import pedersen.physics.Vector;
import pedersen.physics.Velocity;
import pedersen.physics.VelocityVector;
import pedersen.physics.constant.DirectionImpl;
import pedersen.physics.constant.VelocityImpl;

public class VelocityVectorImpl
extends DebuggableBase
implements VelocityVector {
    private final Direction direction;
    private final Velocity velocity;

    public VelocityVectorImpl(HasDirection direction, HasVelocity velocity) {
        this.direction = direction.getDirection();
        this.velocity = velocity.getVelocity();
    }

    public VelocityVectorImpl(HasDirection direction, double velocity) {
        this(direction, new VelocityImpl(velocity));
    }

    public VelocityVectorImpl(double radians, double velocity) {
        this((HasDirection)new DirectionImpl(radians), new VelocityImpl(velocity));
    }

    @Override
    public VelocityVector getVelocityVector() {
        return this;
    }

    @Override
    public Vector getVector() {
        return this;
    }

    @Override
    public boolean equalsVelocityVector(HasVelocityVector other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        return this.direction.equalsDirection(other.getVelocityVector().getDirection()) && this.velocity.equalsVelocity(other.getVelocityVector().getVelocity());
    }

    @Override
    public boolean equalsVector(HasVector other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        return this.direction.equalsDirection(other.getVector().getDirection()) && this.velocity.equalsMagnitude(other.getVector().getMagnitude());
    }

    @Override
    public VelocityVector getReverseVector() {
        return new VelocityVectorImpl((HasDirection)this.direction.getOpposedAngle(), this.velocity.getInverseVelocity());
    }

    @Override
    public Direction getDirection() {
        return this.direction;
    }

    @Override
    public Velocity getVelocity() {
        return this.velocity;
    }

    @Override
    public Magnitude getMagnitude() {
        return this.getVelocity();
    }

    @Override
    public String description() {
        return "(" + this.direction.getAbsoluteRadians() + ", " + this.velocity.velocity() + ")";
    }
}

