/*
 * Decompiled with CFR 0.152.
 */
package pedersen.util;

import java.awt.geom.Rectangle2D;
import pedersen.debug.DebuggableBase;
import pedersen.physics.Direction;
import pedersen.physics.DistanceVector;
import pedersen.physics.HasDirection;
import pedersen.physics.HasPosition;
import pedersen.physics.Position;
import pedersen.physics.SlopeFormula;
import pedersen.physics.constant.DirectionImpl;
import pedersen.physics.constant.DistanceVectorImpl;
import pedersen.physics.constant.PositionImpl;
import pedersen.util.Constraints;

public class Arena
extends DebuggableBase {
    public static Arena singleton = null;
    public static final Direction north = new DirectionImpl(0.0);
    public static final Direction northEast = new DirectionImpl(0.7853981633974483);
    public static final Direction east = new DirectionImpl(1.5707963267948966);
    public static final Direction southEast = new DirectionImpl(2.356194490192345);
    public static final Direction south = new DirectionImpl(Math.PI);
    public static final Direction southWest = new DirectionImpl(3.9269908169872414);
    public static final Direction west = new DirectionImpl(4.71238898038469);
    public static final Direction northWest = new DirectionImpl(5.497787143782138);
    private final SlopeFormula slopeN;
    private final SlopeFormula slopeE;
    private final SlopeFormula slopeW;
    private final SlopeFormula slopeS;
    private final Position minCorner;
    private final Position maxCorner;
    private final Position nwCorner;
    private final Position seCorner;
    private final Position center;
    private static final double minimumDistanceFromWall = 18.0;
    private final double absoluteMinX = 0.0;
    private final double absoluteMinY = 0.0;
    private final double minX = 18.0;
    private final double minY = 18.0;
    private final double absoluteMaxX;
    private final double absoluteMaxY;
    private final double maxX;
    private final double maxY;
    private final Rectangle2D.Double drivableArea;

    public Arena(double battleFieldWidth, double battleFieldHeight) {
        this.absoluteMaxX = battleFieldWidth;
        this.absoluteMaxY = battleFieldHeight;
        this.maxX = this.absoluteMaxX - 18.0;
        this.maxY = this.absoluteMaxY - 18.0;
        this.minCorner = new PositionImpl(18.0, 18.0);
        this.maxCorner = new PositionImpl(this.maxX, this.maxY);
        this.nwCorner = new PositionImpl(18.0, this.maxY);
        this.seCorner = new PositionImpl(this.maxX, 18.0);
        this.drivableArea = new Rectangle2D.Double(18.0, 18.0, this.maxX - 18.0, this.maxY - 18.0);
        this.center = new PositionImpl((0.0 + this.absoluteMaxX) * 0.5, (0.0 + this.absoluteMaxY) * 0.5);
        this.slopeN = new SlopeFormula((HasPosition)this.maxCorner, east);
        this.slopeE = new SlopeFormula((HasPosition)this.maxCorner, north);
        this.slopeW = new SlopeFormula((HasPosition)this.minCorner, north);
        this.slopeS = new SlopeFormula((HasPosition)this.minCorner, east);
    }

    public static void battleSetup() {
    }

    public boolean isInAbsoluteBoundary(HasPosition position) {
        singleton.getClass();
        if (Constraints.isInRange(0.0, position.getPosition().getX(), Arena.singleton.absoluteMaxX)) {
            singleton.getClass();
            if (Constraints.isInRange(0.0, position.getPosition().getY(), Arena.singleton.absoluteMaxY)) {
                return true;
            }
        }
        return false;
    }

    public boolean isVehicleCenterInBoundary(HasPosition position) {
        singleton.getClass();
        if (Constraints.isInRange(18.0, position.getPosition().getX(), Arena.singleton.maxX)) {
            singleton.getClass();
            if (Constraints.isInRange(18.0, position.getPosition().getY(), Arena.singleton.maxY)) {
                return true;
            }
        }
        return false;
    }

    public Position adjustOutOfBoundsTarget(HasPosition chassisPosition, HasPosition targetPosition) {
        Position position = null;
        if (this.isInAbsoluteBoundary(chassisPosition)) {
            if (this.isVehicleCenterInBoundary(targetPosition)) {
                position = targetPosition.getPosition();
            } else if (chassisPosition.getPosition().equalsPosition(targetPosition)) {
                position = null;
            } else {
                Position wallIntercept;
                Direction bearing = chassisPosition.getPosition().getBearing(targetPosition);
                DistanceVectorImpl movementVector = new DistanceVectorImpl((HasDirection)bearing, 1.0);
                position = wallIntercept = this.getWallIntercept(chassisPosition, movementVector);
            }
        } else {
            super.console("ChassisPosition " + new PositionImpl(chassisPosition).description() + " is outside the absolute boundary.");
        }
        return position;
    }

    public Position getWallIntercept(HasPosition position, DistanceVector vector) {
        Position wallIntercept = null;
        if (vector.getDistance().distance() != 0.0) {
            SlopeFormula slope;
            Direction heading = vector.getDirection();
            wallIntercept = singleton.getWallIntercept(position, heading, slope = new SlopeFormula(position, vector), this.slopeN);
            if (wallIntercept == null) {
                wallIntercept = singleton.getWallIntercept(position, heading, slope, this.slopeE);
            }
            if (wallIntercept == null) {
                wallIntercept = singleton.getWallIntercept(position, heading, slope, this.slopeW);
            }
            if (wallIntercept == null) {
                wallIntercept = singleton.getWallIntercept(position, heading, slope, this.slopeS);
            }
            if (wallIntercept == null) {
                super.console("Unable to determine wall intercept for position " + new PositionImpl(position).description() + " and heading " + new DirectionImpl(heading).description() + ".");
            }
        }
        return wallIntercept;
    }

    private Position getWallIntercept(HasPosition position, Direction heading, SlopeFormula a, SlopeFormula b) {
        Position wallIntercept = null;
        Position pointOfIntercept = a.getPointOfIntercept(b);
        if (pointOfIntercept != null && this.isVehicleCenterInBoundary(pointOfIntercept) && (position.getPosition().equalsPosition(pointOfIntercept) || position.getPosition().getBearing(pointOfIntercept).equalsDirection(heading))) {
            wallIntercept = pointOfIntercept.getPosition();
        }
        return wallIntercept;
    }

    public double getDistanceToWall(HasPosition o) {
        return Math.min(Math.min(this.maxY - o.getPosition().getY(), o.getPosition().getY() - 18.0), Math.min(this.maxX - o.getPosition().getX(), o.getPosition().getX() - 18.0));
    }

    public double getDistanceToFarCorner(HasPosition o) {
        return Math.min(Math.max(this.minCorner.getDistance(o).distance(), this.maxCorner.getDistance(o).distance()), Math.max(this.nwCorner.getDistance(o).distance(), this.seCorner.getDistance(o).distance()));
    }

    public static Position getCenter() {
        return Arena.singleton.center;
    }

    public double getAbsoluteMinX() {
        return 0.0;
    }

    public double getAbsoluteMinY() {
        return 0.0;
    }

    public double getAbsoluteMaxX() {
        return this.absoluteMaxX;
    }

    public double getAbsoluteMaxY() {
        return this.absoluteMaxY;
    }

    public Rectangle2D.Double getDrivableArea() {
        return this.drivableArea;
    }

    public static double getMinX() {
        singleton.getClass();
        return 18.0;
    }

    public static double getMinY() {
        singleton.getClass();
        return 18.0;
    }

    public static double getMaxX() {
        return Arena.singleton.maxX;
    }

    public static double getMaxY() {
        return Arena.singleton.maxY;
    }

    @Override
    public String description() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getClass().getSimpleName());
        buffer.append("\n").append("Min corner: " + this.minCorner.description());
        buffer.append("\n").append("Max corner: " + this.maxCorner.description());
        return buffer.toString();
    }
}

