/*
 * Decompiled with CFR 0.152.
 */
package dhn;

import java.awt.Color;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.Robot;
import robocode.ScannedRobotEvent;
import robocode.WinEvent;
import robocode.util.Utils;

public class Immortal
extends Robot {
    double bulletPower = 3.0;
    double bulletSpeed = 20.0 - 3.0 * this.bulletPower;
    static double previousEnergy = 100.0;

    public void run() {
        this.setAdjustGunForRobotTurn(true);
        this.setAdjustRadarForGunTurn(true);
        this.setAdjustRadarForRobotTurn(true);
        this.setColors(Color.BLACK, Color.WHITE, Color.RED);
        while (true) {
            this.turnRadarRight(360.0);
            double x = Math.random() * 300.0 + 200.0;
            this.ahead(x);
            this.turnRadarRight(360.0);
            this.back(x);
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        double gunTurn = this.getHeading() - this.getGunHeading() + e.getBearing();
        this.turnGunRight(Utils.normalRelativeAngleDegrees((double)gunTurn));
        double eEnergy = e.getEnergy();
        if (previousEnergy - eEnergy > 0.0 && previousEnergy - eEnergy <= 3.0) {
            this.ahead(40.0);
        }
        previousEnergy = eEnergy;
        this.fireBullet(this.bulletPower);
    }

    public void onBulletMissed(BulletMissedEvent e) {
        this.bulletPower -= 0.5;
    }

    public void onBulletHit(BulletHitEvent e) {
        this.bulletPower += 0.5;
    }

    public void onHitByBullet(HitByBulletEvent e) {
        double angleToTurn;
        this.turnLeft(90.0 - e.getBearing());
        String attacker = e.getName();
        double attackHeading = e.getHeading();
        double attackBearing = e.getBearing();
        double bulletVelocity = e.getVelocity();
        double bulletPower = e.getPower();
        System.out.printf("Attacked by a bullet with the power of %.2f at a velocity of %.2f from %s from heading %4.0f\u00b0 and bearing %4.0f\u00b0\n ", bulletPower, bulletVelocity, attacker, attackHeading, attackBearing);
        double gunHeading = this.getGunHeading();
        System.out.printf("Gun heading is %4.0f\u00b0 ", gunHeading);
        double headingToAim = 180.0 + attackHeading;
        if (headingToAim > 180.0) {
            headingToAim -= 360.0;
        }
        if (headingToAim < -180.0) {
            headingToAim += 360.0;
        }
        if ((angleToTurn = headingToAim - gunHeading) > 180.0) {
            angleToTurn -= 360.0;
        }
        if (angleToTurn < -180.0) {
            angleToTurn += 360.0;
        }
        System.out.printf(" but should be %4.0f\u00b0. Turn gun %4.0f\u00b0. \n", headingToAim, angleToTurn);
        this.turnGunRight(angleToTurn);
        this.fire(2.0);
    }

    public void onHitWall(HitWallEvent e) {
        double wallBearing = e.getBearing();
        this.turnLeft(Utils.normalRelativeAngleDegrees((double)(90.0 - wallBearing)));
        this.ahead(200.0);
    }

    public void onHitRobot(HitRobotEvent e) {
        this.turnLeft(Utils.normalRelativeAngleDegrees((double)(90.0 - e.getBearing())));
    }

    public void onWin(WinEvent e) {
        for (int i = 0; i < 50; ++i) {
            this.turnRight(30.0);
            this.turnLeft(30.0);
        }
    }
}

