/*
 * Decompiled with CFR 0.152.
 */
package rdt.Wraith.Guns.GunImplementations;

import java.awt.geom.Point2D;
import rdt.Wraith.Guns.FiringData;
import rdt.Wraith.Guns.FiringSolutions;
import rdt.Wraith.Guns.Gun;
import rdt.Wraith.IRobot;
import rdt.Wraith.RobotSnapshots.RobotSnapshot;
import rdt.Wraith.RobotSnapshots.RobotSnapshots;
import rdt.Wraith.Stats.IStats;
import rdt.Wraith.Utils.MathUtils;

public class IterativeCircularWithWallStopping
extends Gun {
    public IterativeCircularWithWallStopping(String ownerName, IRobot robot, RobotSnapshots targetSnapshots, IStats stats) {
        super(ownerName + " : Iterative Circular with Wall Stopping", robot, targetSnapshots, stats);
    }

    @Override
    public void GetFiringSolutions(FiringData firingData, FiringSolutions outSolutions) {
        double predictedY;
        double predictedX;
        double myY;
        double myX;
        block1: {
            double deltaTime = 0.0;
            myX = firingData.SourceX;
            myY = firingData.SourceY;
            RobotSnapshot snapshot = firingData.TargetAtFiringTick;
            double enemyHeading = snapshot.AbsoluteHeading;
            double enemyVelocity = snapshot.VelocityAlongHeading;
            double battleFieldWidth = this._robot.getBattleFieldWidth();
            double battleFieldHeight = this._robot.getBattleFieldHeight();
            predictedX = snapshot.LocationX;
            predictedY = snapshot.LocationY;
            RobotSnapshot prevSnapshot = this._targetSnapshots.Read(firingData.FiringTick - 1L);
            double enemyHeadingChange = snapshot.AbsoluteHeading - prevSnapshot.AbsoluteHeading;
            do {
                double d;
                deltaTime += 1.0;
                if (!(d * firingData.BulletVelocity < Point2D.Double.distance(myX, myY, predictedX, predictedY))) break block1;
                predictedY += Math.cos(enemyHeading) * enemyVelocity;
            } while (!((predictedX += Math.sin(enemyHeading += enemyHeadingChange) * enemyVelocity) < 18.0 || predictedY < 18.0 || predictedX > battleFieldWidth - 18.0) && !(predictedY > battleFieldHeight - 18.0));
            predictedX = Math.min(Math.max(18.0, predictedX), battleFieldWidth - 18.0);
            predictedY = Math.min(Math.max(18.0, predictedY), battleFieldHeight - 18.0);
        }
        outSolutions.WriteSolution(MathUtils.GetAngle(myX, myY, predictedX, predictedY), 1.0, this);
    }
}

