/*
 * Decompiled with CFR 0.152.
 */
package rdt.Wraith.Profiling;

import rdt.Wraith.IBattleEndedEventHandler;
import rdt.Wraith.IRobot;
import rdt.Wraith.IRoundEndedEventHandler;
import rdt.Wraith.IRoundStartedEventHandler;
import rdt.Wraith.Profiling.ProfileTreeNode;
import robocode.BattleEndedEvent;
import robocode.RoundEndedEvent;

public class Profiler
implements IRoundStartedEventHandler,
IRoundEndedEventHandler,
IBattleEndedEventHandler {
    private static ProfileTreeNode _root;
    private static ProfileTreeNode _currentNode;
    private static boolean _profiling;

    public Profiler(IRobot robot) {
        robot.RegisterForEventHandling(this);
        robot.RegisterForEventHandling(this);
        robot.RegisterForEventHandling(this);
    }

    @Override
    public void OnRoundStartedEvent() {
        _currentNode = _root;
        _profiling = true;
    }

    public static void StartScope(String name) {
        if (_profiling) {
            _currentNode = _currentNode.StartSubScope(name);
        }
    }

    public static void EndScope() {
        if (_profiling && _currentNode != _root) {
            _currentNode = _currentNode.EndScope();
        }
    }

    @Override
    public void OnRoundEndedEvent(RoundEndedEvent event) {
        _profiling = false;
        _currentNode = _root;
    }

    @Override
    public void OnBattleEndedEvent(BattleEndedEvent event) {
        System.out.println("PROFILING:");
        System.out.println("");
        Profiler.DumpToConsoleRecursive(_root, 0);
        System.out.println("");
    }

    private static void DumpToConsoleRecursive(ProfileTreeNode node, int depth) {
        if (node != _root && node.Visits > 0L) {
            StringBuilder nodeData = new StringBuilder();
            for (int index = 0; index < depth; ++index) {
                nodeData.append("   ");
            }
            nodeData.append(node.Name);
            nodeData.append(" Visits ").append(node.Visits);
            nodeData.append(" Avg ").append(Profiler.ToMillisecondsString(node.TotalTimeInFunction / node.Visits));
            nodeData.append(" Min ").append(Profiler.ToMillisecondsString(node.MinTimeInFunction));
            nodeData.append(" Max ").append(Profiler.ToMillisecondsString(node.MaxTimeInFunction));
            nodeData.append(" Total ").append(Profiler.ToMillisecondsString(node.TotalTimeInFunction));
            System.out.println(nodeData.toString());
        }
        for (ProfileTreeNode child : node.Children.values()) {
            Profiler.DumpToConsoleRecursive(child, depth + 1);
        }
    }

    private static String ToMillisecondsString(long nanoseconds) {
        double ms = (float)nanoseconds / 1000000.0f;
        return "" + ms;
    }

    static {
        _currentNode = _root = new ProfileTreeNode("Root");
        _profiling = false;
    }
}

