/*
 * Decompiled with CFR 0.152.
 */
package gun;

import execution.Sequencer;
import gun.MovePredictor;
import java.awt.geom.Point2D;
import math.Vect2d;
import robocode.Rules;
import robocode.util.Utils;

public class SequencerPredictor
extends MovePredictor {
    Sequencer _sequencer;
    private double _velocity;
    private double _heading;

    public SequencerPredictor(double velocity, double heading, Sequencer sequencer) {
        this._velocity = velocity;
        this._heading = heading;
        this._sequencer = sequencer;
    }

    @Override
    public void Step(Point2D.Double start) {
        double distanceRemaining = this.DoubleOr((Double)this._sequencer.move.remaining, 0.0);
        double nextMove = this.DoubleOr((Double)this._sequencer.move.peek(), distanceRemaining);
        double maxVelocity = this.DoubleOr(this._sequencer.limitVelocity.peek(), 8.0);
        double maxHeadingDelta = this.DoubleOr(this._sequencer.limitTurn.peek(), Rules.MAX_TURN_RATE_RADIANS);
        double remainingTurn = this.DoubleOr((Double)this._sequencer.turn.remaining, 0.0);
        double newVelocity = this.getNewVelocity(this._velocity, nextMove, maxVelocity);
        double newHeading = this.updateHeading(this._heading, this._velocity, remainingTurn, maxHeadingDelta);
        Vect2d vector = Vect2d.fromHeading(newHeading, newVelocity);
        vector.movePoint(start);
    }

    private double DoubleOr(Double value, double defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    private double updateHeading(double heading, double velocity, double remainingTurn, double maxTurnRate) {
        boolean normalizeHeading = true;
        double turnRate = Math.min(maxTurnRate, (0.4 + 0.6 * (1.0 - Math.abs(velocity) / 8.0)) * Rules.MAX_TURN_RATE_RADIANS);
        if (remainingTurn > 0.0) {
            heading += Math.min(remainingTurn, turnRate);
        } else if (remainingTurn < 0.0) {
            heading += Math.max(remainingTurn, -turnRate);
        } else {
            normalizeHeading = false;
        }
        if (normalizeHeading) {
            heading = remainingTurn == 0.0 ? Utils.normalNearAbsoluteAngle((double)heading) : Utils.normalAbsoluteAngle((double)heading);
        }
        return heading;
    }

    private double getNewVelocity(double velocity, double distance, double nextMaxVelocity) {
        if (distance < 0.0) {
            return -this.getNewVelocity(-velocity, -distance, nextMaxVelocity);
        }
        double goalVel = distance == Double.POSITIVE_INFINITY ? nextMaxVelocity : Math.min(SequencerPredictor.getMaxVelocity(distance), nextMaxVelocity);
        if (velocity >= 0.0) {
            return Math.max(velocity - 2.0, Math.min(goalVel, velocity + 1.0));
        }
        return Math.max(velocity - 1.0, Math.min(goalVel, velocity + SequencerPredictor.maxDecel(-velocity)));
    }

    private static final double getMaxVelocity(double distance) {
        double decelTime = Math.max(1.0, Math.ceil((Math.sqrt(4.0 * distance + 1.0) - 1.0) / 2.0));
        if (decelTime == Double.POSITIVE_INFINITY) {
            return 8.0;
        }
        double decelDist = decelTime / 2.0 * (decelTime - 1.0) * 2.0;
        return (decelTime - 1.0) * 2.0 + (distance - decelDist) / decelTime;
    }

    private static double maxDecel(double speed) {
        double decelTime = speed / 2.0;
        double accelTime = 1.0 - decelTime;
        return Math.min(1.0, decelTime) * 2.0 + Math.max(0.0, accelTime) * 1.0;
    }
}

