/*
 * Decompiled with CFR 0.152.
 */
package ags.muse.gun.vcs;

import ags.muse.gun.IStatTracker;
import ags.muse.gun.SWave;
import ags.muse.gun.segmentation.Dimension;
import ags.muse.gun.segmentation.DimensionData;
import ags.muse.gun.segmentation.SegmentConfig;
import ags.muse.gun.segmentation.SegmentedStorage;
import ags.muse.recon.EnemyList;
import ags.muse.recon.SelfStatus;
import ags.util.Range;

public abstract class VCSBufferGroup
implements IStatTracker {
    private final SegmentedStorage buffers;

    public VCSBufferGroup(SegmentConfig config, int bins) {
        this.buffers = new SegmentedStorage(config, bins);
    }

    public VCSBufferGroup(SegmentConfig config, int bins, double halfLife) {
        this.buffers = new SegmentedStorage(config, bins, halfLife);
    }

    @Override
    public double[] getBins(SWave wave) {
        Dimension.Data<Double> seg = DimensionData.get(wave);
        if (seg == null) {
            System.out.println("Error: Wave without segment data!");
            return null;
        }
        return this.buffers.getInterpolatedBuffer(seg);
    }

    public void recordWave(SWave wave, double weight) {
        this.recordWave(wave, wave.getHitRange(), weight);
    }

    public void recordWave(SWave wave, Range hitRange, double weight) {
        if (weight == 0.0) {
            return;
        }
        Dimension.Data<Double> seg = DimensionData.get(wave);
        if (seg == null) {
            System.out.println("Error: Wave without segment data!");
            return;
        }
        this.buffers.recordGF(seg, hitRange, weight);
    }

    public void incrementAge() {
        this.buffers.incrementAge();
    }

    @Override
    public void waveStarted(SelfStatus status, EnemyList enemyList, SWave wave) {
        if (wave.target == null) {
            System.out.println("ERROR: Wave without target!");
            return;
        }
        DimensionData.put(wave, status, wave.target);
    }

    @Override
    public void waveEnded(SWave wave) {
    }

    @Override
    public void bulletHit(SWave wave) {
    }

    @Override
    public void bulletHitBullet(SWave wave) {
    }
}

