/*
 * Decompiled with CFR 0.152.
 */
package org.la4j.matrix;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.Random;
import org.la4j.Matrices;
import org.la4j.Matrix;
import org.la4j.Vector;
import org.la4j.iterator.RowMajorMatrixIterator;
import org.la4j.iterator.VectorIterator;
import org.la4j.matrix.ColumnMajorSparseMatrix;
import org.la4j.matrix.SparseMatrix;
import org.la4j.matrix.sparse.CRSMatrix;
import org.la4j.operation.MatrixMatrixOperation;
import org.la4j.operation.MatrixOperation;
import org.la4j.operation.MatrixVectorOperation;

public abstract class RowMajorSparseMatrix
extends SparseMatrix {
    public static RowMajorSparseMatrix zero(int rows, int columns) {
        return CRSMatrix.zero(rows, columns);
    }

    public static RowMajorSparseMatrix zero(int rows, int columns, int capacity) {
        return CRSMatrix.zero(rows, columns, capacity);
    }

    public static RowMajorSparseMatrix diagonal(int size, double diagonal) {
        return CRSMatrix.diagonal(size, diagonal);
    }

    public static RowMajorSparseMatrix identity(int size) {
        return CRSMatrix.identity(size);
    }

    public static RowMajorSparseMatrix random(int rows, int columns, double density, Random random) {
        return CRSMatrix.random(rows, columns, density, random);
    }

    public static RowMajorSparseMatrix randomSymmetric(int size, double density, Random random) {
        return CRSMatrix.randomSymmetric(size, density, random);
    }

    public static RowMajorSparseMatrix from1DArray(int rows, int columns, double[] array) {
        return CRSMatrix.from1DArray(rows, columns, array);
    }

    public static RowMajorSparseMatrix from2DArray(double[][] array) {
        return CRSMatrix.from2DArray(array);
    }

    public static RowMajorSparseMatrix block(Matrix a, Matrix b, Matrix c, Matrix d) {
        return CRSMatrix.block(a, b, c, d);
    }

    public static RowMajorSparseMatrix fromCSV(String csv) {
        return Matrix.fromCSV(csv).to(Matrices.SPARSE_ROW_MAJOR);
    }

    public static RowMajorSparseMatrix fromMatrixMarket(String mm) {
        return Matrix.fromMatrixMarket(mm).to(Matrices.SPARSE_ROW_MAJOR);
    }

    public RowMajorSparseMatrix(int rows, int columns) {
        super(rows, columns);
    }

    public RowMajorSparseMatrix(int rows, int columns, int cardinality) {
        super(rows, columns, cardinality);
    }

    @Override
    public boolean isRowMajor() {
        return true;
    }

    @Override
    public Matrix transpose() {
        ColumnMajorSparseMatrix result = ColumnMajorSparseMatrix.zero(this.columns, this.rows);
        RowMajorMatrixIterator it = this.nonZeroRowMajorIterator();
        while (it.hasNext()) {
            double x = (Double)it.next();
            int i = it.rowIndex();
            int j = it.columnIndex();
            result.set(j, i, x);
        }
        return result;
    }

    @Override
    public Matrix rotate() {
        ColumnMajorSparseMatrix result = ColumnMajorSparseMatrix.zero(this.columns, this.rows);
        Iterator<Integer> nzRows = this.iteratorOfNonZeroRows();
        LinkedList<Integer> reversedNzRows = new LinkedList<Integer>();
        while (nzRows.hasNext()) {
            reversedNzRows.add(0, nzRows.next());
        }
        Iterator i$ = reversedNzRows.iterator();
        while (i$.hasNext()) {
            int i = (Integer)i$.next();
            VectorIterator it = this.nonZeroIteratorOfRow(i);
            while (it.hasNext()) {
                double x = (Double)it.next();
                int j = it.index();
                result.set(j, this.rows - 1 - i, x);
            }
        }
        return result;
    }

    public abstract Iterator<Integer> iteratorOfNonZeroRows();

    @Override
    public <T> T apply(MatrixOperation<T> operation) {
        operation.ensureApplicableTo(this);
        return operation.apply(this);
    }

    @Override
    public <T> T apply(MatrixMatrixOperation<T> operation, Matrix that) {
        return that.apply(operation.partiallyApply(this));
    }

    @Override
    public <T> T apply(MatrixVectorOperation<T> operation, Vector that) {
        return that.apply(operation.partiallyApply(this));
    }
}

