/*
 * Decompiled with CFR 0.152.
 */
package bjl.fire;

import bjl.BattleField;
import bjl.Blip;
import bjl.Enemy;
import bjl.FireDemand;
import bjl.PatternBlip;
import bjl.Point;
import bjl.fire.FireStrategy;

public class BulletDodge
extends FireStrategy {
    public String toString() {
        return "BulletDodge";
    }

    public Point getPosition(long time) {
        Blip b = new Blip(this.enemy.getBlipBefore(time));
        long now = b.time;
        long then = this.enemy.getFireTimeBefore(time - 23L);
        long deltaTime = 0L;
        if (time - now > 23L || then == (long)-1) {
            return b.pos;
        }
        int i = 0;
        while ((long)i + now < time) {
            ++deltaTime;
            PatternBlip p = this.enemy.getPBlip((long)i + then);
            if (p != null) {
                b.head += p.turnRate * (double)deltaTime;
                b.pos.x += Math.sin(Math.toRadians(b.head)) * p.vel * (double)deltaTime;
                b.pos.y += Math.cos(Math.toRadians(b.head)) * p.vel * (double)deltaTime;
                b.vel = p.vel;
                deltaTime = 0L;
            }
            ++i;
        }
        b.pos.x += Math.sin(Math.toRadians(b.head)) * b.vel * (double)deltaTime;
        b.pos.y += Math.cos(Math.toRadians(b.head)) * b.vel * (double)deltaTime;
        return b.pos;
    }

    protected FireDemand getFireDemand() {
        Blip b = new Blip(this.enemy.getLastBlip());
        Point pos = BattleField.getPos();
        Point them = new Point(b.pos);
        long now = b.time;
        long then = this.enemy.getFireTimeBefore(BattleField.getTime() - 23L);
        long deltaTime = 0L;
        if (then < 0L) {
            return new FireDemand(0.0, -1.0, 0.0, 0.0, this);
        }
        double power = this.getPower(them.dist(pos));
        double prob = this.getProb();
        if (power < 0.1) {
            power = 0.1;
        }
        if (power > (double)3) {
            power = 3;
        }
        int i = 0;
        while (i < 23) {
            Point bulletPos = Point.makePoint(pos, pos.angleTo(them), (20.0 - (double)3 * power) * (double)(now + (long)i - BattleField.getTime()));
            if (Math.abs(bulletPos.dist(them)) < 10.0) break;
            ++deltaTime;
            PatternBlip p = this.enemy.getPBlip((long)i + then);
            if (p == null) {
                them.x += Math.sin(Math.toRadians(b.head)) * b.vel;
                them.y += Math.cos(Math.toRadians(b.head)) * b.vel;
            } else {
                int j = 0;
                while ((long)j < deltaTime) {
                    b.head += p.turnRate;
                    b.pos.x += Math.sin(Math.toRadians(b.head)) * p.vel;
                    b.pos.y += Math.cos(Math.toRadians(b.head)) * p.vel;
                    ++j;
                }
                b.vel = p.vel;
                them = new Point(b.pos);
                deltaTime = 0L;
            }
            ++i;
        }
        double bear = pos.angleTo(them);
        double dist = pos.dist(them);
        if (them.isOutsideArena()) {
            return new FireDemand(0.0, -1.0, 0.0, 0.0, this);
        }
        if (this.bulletsFired < 5) {
            prob = 1.0;
        }
        return new FireDemand(power, prob, bear, dist, this);
    }

    public BulletDodge(Enemy t) {
        super(t);
        this.avb = false;
    }
}

