/*
 * Decompiled with CFR 0.152.
 */
package de.simpleworks.robocode.strategy;

import de.simpleworks.robocode.debug.Debug;
import de.simpleworks.robocode.stats.EnemyStat;
import de.simpleworks.robocode.stats.EnemyStats;
import de.simpleworks.robocode.strategy.fire.FSPredictiveLinear;
import de.simpleworks.robocode.strategy.fire.FSSimple;
import de.simpleworks.robocode.strategy.fire.FireStrategy;
import java.util.HashMap;
import java.util.Random;

public class FireStrategyManager {
    public static final String FS_SIMPLE = "fs_simple";
    public static final String FS_PRED_LIN = "fs_predicted_linear";
    private EnemyStats FEnemyStats;
    private HashMap<String, FireStrategy> FStrategyMap = new HashMap();

    protected boolean hasStats() {
        return this.FEnemyStats != null;
    }

    public FireStrategyManager() {
        this.FStrategyMap.put(FS_SIMPLE, new FSSimple());
        this.FStrategyMap.put(FS_PRED_LIN, new FSPredictiveLinear());
    }

    public void registerStats(EnemyStats _es) {
        this.FEnemyStats = _es;
    }

    public FireStrategy getStrategy(String _tName) {
        EnemyStat eStat;
        String myChoice = FS_PRED_LIN;
        if (this.hasStats() && (eStat = this.FEnemyStats.getStat(_tName)) != null && (myChoice = eStat.getPrefFireStrategy(this.FStrategyMap.size())).equals("NONE")) {
            Random w = new Random();
            int choice = w.nextInt(this.FStrategyMap.size());
            Object[] keys = this.FStrategyMap.keySet().toArray();
            myChoice = (String)keys[choice];
        }
        Debug.print(true, "Choosen Strategy: " + myChoice);
        return this.FStrategyMap.get(myChoice);
    }
}

