/*
 * Decompiled with CFR 0.152.
 */
package ultra;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jdg.tools.BotMove;
import jdg.tools.BotTrigo;
import jdg.tools.RobotState;
import robocode.HitByBulletEvent;
import robocode.RoundEndedEvent;
import ultra.core.BotDump;
import ultra.core.JMapMathToolBox;
import ultra.core.LogEntry;
import ultra.core.Skeleton;
import ultra.core.Utils;
import ultra.strategies.guns.KiTIGun;

public class Defender
extends Skeleton {
    public static double NEAR_RADIUS = 28.0;
    private KiTIGun weapon = new KiTIGun();
    private List<Rectangle2D.Double> corners;
    private final Map<Integer, UltraBullet> bullets = new HashMap<Integer, UltraBullet>();
    private int avoidingHash = 0;
    private long lastAvoidingTime = 0L;

    @Override
    protected void initialize() {
        super.initialize();
        this.setBulletColor(Color.white);
        double cornerLength = 100.0;
        this.corners = new ArrayList<Rectangle2D.Double>();
        this.corners.add(new Rectangle2D.Double(0.0, 0.0, cornerLength, cornerLength));
        this.corners.add(new Rectangle2D.Double(this.arena.getWidth() - cornerLength, 0.0, cornerLength, cornerLength));
        this.corners.add(new Rectangle2D.Double(this.arena.getWidth() - cornerLength, this.arena.getHeight() - cornerLength, cornerLength, cornerLength));
        this.corners.add(new Rectangle2D.Double(0.0, this.arena.getHeight() - cornerLength, cornerLength, cornerLength));
    }

    public void onRoundEnded(RoundEndedEvent event) {
        UltraBullet.corrections.clear();
        super.onRoundEnded(event);
    }

    private int hashBullet(UltraBullet b) {
        return new Integer((int)b.getHeading()).hashCode() ^ new Integer((int)b.getPower()).hashCode();
    }

    @Override
    protected void doGun(BotDump r) {
        this.weapon.run(r, this.log);
    }

    @Override
    public void onHitByBullet(HitByBulletEvent event) {
        super.onHitByBullet(event);
        long time = event.getTime();
        UltraBullet ub1 = null;
        UltraBullet[] array = new UltraBullet[this.bullets.values().size()];
        array = this.bullets.values().toArray(array);
        int i = array.length - 1;
        while (i >= 0) {
            UltraBullet b = array[i];
            double dist = Utils.dist2Pts(this.getX(), this.getY(), b.getX(), b.getY());
            if (b.getTraveledDistance(time) >= dist - NEAR_RADIUS && b.getTraveledDistance(time) <= dist + NEAR_RADIUS) {
                ub1 = b;
                break;
            }
            --i;
        }
        if (ub1 != null) {
            double realBulletHeading = event.getHeading();
            UltraBullet.addCorrection(new UltraCorrection(ub1.getEstimatedHeading() - realBulletHeading, time));
        }
    }

    private List<UltraBullet> getDangerousBullets(BotDump r, long time) {
        ArrayList<UltraBullet> dangerB = new ArrayList<UltraBullet>();
        for (UltraBullet b : this.bullets.values()) {
            if (!b.isDangerous(r.getX(), r.getY(), r.getHeading(), r.getVelocity(), time)) continue;
            dangerB.add(b);
        }
        return dangerB;
    }

    @Override
    protected void doRadar(BotDump r, LogEntry l) {
        super.doRadar(r, l);
        if (l != null && !this.isWallAvoiding()) {
            boolean tooFar = false;
            boolean isInCorner = false;
            boolean isTooNear = false;
            if (this.log != null && this.log.getLatest() != null) {
                double dist = Utils.dist2Pts(r.getX(), r.getY(), this.log.getLatest().x, this.log.getLatest().y);
                for (Rectangle2D.Double corner : this.corners) {
                    if (!corner.contains(r)) continue;
                    isInCorner = true;
                    break;
                }
                if (isInCorner) {
                    BotMove.to(new RobotState(this), this.getArena().getWidth() / 2.0, this.getArena().getY() / 2.0);
                } else if (dist > 450.0) {
                    tooFar = true;
                    BotMove.to(new RobotState(this), this.log.getLatest());
                } else if (dist < 150.0) {
                    isTooNear = true;
                    this.setAheadCoef(1.0);
                    BotMove.rotate(new RobotState(this), Utils.fixAngle(180.0 - this.log.getLatest().heading));
                    this.setAhead(100.0);
                }
            }
            if (!(tooFar || isInCorner || isTooNear)) {
                Utils.rotate(r, BotTrigo.angle(r, l) + 90.0);
            }
        }
        List<UltraBullet> warningBullets = this.getDangerousBullets(r, this.getTime());
        long time = this.getTime();
        if (!warningBullets.isEmpty()) {
            double minDist = Double.MAX_VALUE;
            UltraBullet minB = null;
            for (UltraBullet b : warningBullets) {
                double dist = Utils.dist2Pts(r, b.getFutureLocation(time));
                if (!(minDist > dist)) continue;
                minDist = dist;
                minB = b;
            }
            if (minDist > 0.0 && minDist < 200.0) {
                this.evitement(r, minB);
            }
        }
    }

    private void evitement(BotDump r, UltraBullet b) {
        if (this.isWallAvoiding()) {
            return;
        }
        UltraAimPoint nearest = b.getDangerousAimPoints();
        if (nearest != null) {
            if (r.getTime() - this.lastAvoidingTime < 2L) {
                this.lastAvoidingTime = r.getTime();
            } else if (this.avoidingHash == 0 || this.avoidingHash != nearest.hashCode()) {
                this.avoidingHash = nearest.hashCode();
                r.reverse();
                System.out.println("Avoiding!" + this.avoidingHash);
            }
        }
        this.lastAvoidingTime = r.getTime();
    }

    @Override
    protected void onRobotFired(double bulletPower) {
        LogEntry oponent = this.log.getLatest();
        BotDump me = new BotDump(this);
        double angle = Math.toDegrees(Utils.angle3Pts(me, oponent, JMapMathToolBox.projectPoint(me, 100.0, this.getHeading())));
        double predictionFactor = 0.0;
        if (angle > 5.0 && angle < 25.0) {
            predictionFactor = 0.2;
        } else if (angle >= 25.0 && angle < 45.0) {
            predictionFactor = 0.5;
        } else if (angle >= 45.0 && angle < 135.0) {
            predictionFactor = 1.0;
        } else if (angle >= 135.0 && angle < 160.0) {
            predictionFactor = 0.5;
        } else if (angle >= 160.0 && angle < 175.0) {
            predictionFactor = 0.2;
        } else if (angle >= 185.0 && angle < 205.0) {
            predictionFactor = -0.2;
        } else if (angle >= 205.0 && angle < 225.0) {
            predictionFactor = -0.5;
        } else if (angle >= 225.0 && angle < 315.0) {
            predictionFactor = -1.0;
        } else if (angle >= 315.0 && angle < 340.0) {
            predictionFactor = -0.5;
        } else if (angle >= 340.0 && angle < 355.0) {
            predictionFactor = -0.2;
        }
        UltraBullet b = new UltraBullet(oponent, BotTrigo.getHeadingTo(oponent, me), bulletPower, oponent.name, this.getTime(), predictionFactor * (me.getVelocity() / 8.0));
        this.bullets.put(this.hashBullet(b), b);
    }

    @Override
    protected void doTick() {
        long time = this.getTime();
        for (UltraBullet b : this.bullets.values()) {
            if (!b.isActive() || !(b.getTraveledDistance(time) > this.arena.getWidth())) continue;
            b.setInactive();
        }
    }

    @Override
    protected void doMove(BotDump r) {
        this.setAhead(150.0);
    }

    @Override
    protected void doParseLogs() {
    }

    @Override
    protected void doAvoidWall(BotDump r) {
        r.reverse();
        this.setAhead(80.0);
    }

    @Override
    protected Color getBotColor() {
        return Color.gray;
    }

    private void drawBullet(Graphics2D g, Point2D p1, Point2D p2, Color c, String label) {
        g.setColor(c);
        g.drawString(label, (int)p1.getX(), (int)p1.getY());
        g.drawLine((int)p1.getX(), (int)p1.getY(), (int)p2.getX(), (int)p2.getY());
    }

    @Override
    public void onPaint(Graphics2D g) {
        super.onPaint(g);
    }

    private void drawJauge(Graphics2D g, int x, int y, double maxValue, double value, Color c, String label) {
        int length = 80;
        int tickHeight = 5;
        int jaugeHeight = 3;
        g.setColor(Color.white);
        g.drawLine(x, y, x + length, y);
        int i = x;
        while (i <= x + length) {
            g.drawLine(i, y, i, y + tickHeight);
            i += 5;
        }
        g.setColor(c);
        g.fillRect(x, y, (int)(value * (double)length / maxValue), jaugeHeight);
        g.drawString(label, x + length + 5, y);
    }

    public static class UltraAimPoint
    extends Point2D.Double {
        private UltraBullet ub;
        private double heading;

        public UltraAimPoint(UltraBullet b, Point2D position, double heading) {
            super(position.getX(), position.getY());
            this.ub = b;
            this.heading = heading;
        }

        @Override
        public int hashCode() {
            System.out.println(this.heading);
            return new Double(this.heading).hashCode() ^ this.ub.hashCode();
        }
    }

    public static class UltraBullet
    extends Point2D.Double {
        private static final long serialVersionUID = 6350732096599440123L;
        private String owner;
        private double power;
        private double heading;
        private boolean isActive = true;
        private long fireTime;
        private double direction = 0.0;
        private double estimatedAddedAngle = 30.0;
        private static List<UltraCorrection> corrections = new ArrayList<UltraCorrection>();
        private UltraAimPoint cache;

        private static void addCorrection(UltraCorrection c) {
            boolean found = false;
            for (UltraCorrection otherc : corrections) {
                if (!(Math.abs(otherc.correctionAngle - c.correctionAngle) < 5.0)) continue;
                ++otherc.nbHit;
                otherc.addTime = c.addTime;
                found = true;
            }
            if (!found) {
                corrections.add(c);
                if (corrections.size() > 5) {
                    int toDelete = 1;
                    int i = 0;
                    while (i < toDelete) {
                        long maxTime = 0L;
                        int minIdx = -1;
                        int j = 0;
                        while (j < corrections.size()) {
                            if (UltraBullet.corrections.get((int)j).addTime > maxTime) {
                                maxTime = UltraBullet.corrections.get((int)j).addTime;
                                minIdx = j;
                            }
                            ++j;
                        }
                        if (minIdx != -1) {
                            corrections.remove(minIdx);
                        }
                        ++i;
                    }
                }
            }
        }

        @Override
        public int hashCode() {
            return this.owner.hashCode() ^ new Long(this.fireTime).hashCode();
        }

        private UltraBullet(Point2D.Double pos, double heading, double firePower, String owner, long time) {
            super(pos.getX(), pos.getY());
            this.heading = heading;
            this.power = firePower;
            this.owner = owner;
            this.fireTime = time - 1L;
        }

        public UltraBullet(Point2D.Double pos, double heading, double firePower, String owner, long time, double direction) {
            this(pos, heading, firePower, owner, time);
            this.direction = direction;
        }

        public UltraAimPoint getDangerousAimPoints() {
            return this.cache;
        }

        public UltraAimPoint getDangerousAimPoints(double x, double y, double heading, double velocity, long time) {
            this.cache = null;
            long t = time;
            while (t < time + 150L) {
                Point2D.Double r = JMapMathToolBox.projectPoint(new Point2D.Double(x, y), velocity * (double)(t - time), heading);
                UltraAimPoint b = this.getFutureLocation(t);
                if (Utils.dist2Pts(b.getX(), b.getY(), ((Point2D)r).getX(), ((Point2D)r).getY()) <= NEAR_RADIUS) {
                    this.cache = b;
                    return b;
                }
                ArrayList<UltraAimPoint> correctedLocations = this.getFutureCorrectedLocation(t);
                for (UltraAimPoint ump : correctedLocations) {
                    if (!(Utils.dist2Pts(ump.getX(), ump.getY(), ((Point2D)r).getX(), ((Point2D)r).getY()) <= NEAR_RADIUS)) continue;
                    this.cache = ump;
                    return ump;
                }
                ++t;
            }
            return this.cache;
        }

        public boolean isDangerous(double x, double y, double heading, double velocity, long time) {
            return this.getDangerousAimPoints(x, y, heading, velocity, time) != null;
        }

        public double getEstimatedHeading() {
            return Utils.fixAngle(this.getHeading() + this.estimatedAddedAngle * this.direction);
        }

        public List<Double> getEstimatedCorrectedHeading() {
            ArrayList<Double> angles = new ArrayList<Double>();
            for (UltraCorrection correction : corrections) {
                angles.add(Utils.fixAngle(this.getHeading() + this.estimatedAddedAngle * this.direction - correction.correctionAngle * Math.signum(this.direction)));
            }
            return angles;
        }

        public UltraAimPoint getFutureLocation(long time) {
            return new UltraAimPoint(this, BotTrigo.getPosition(this, this.getEstimatedHeading(), this.getTraveledDistance(time)), this.getEstimatedHeading());
        }

        public ArrayList<UltraAimPoint> getFutureCorrectedLocation(long time) {
            ArrayList<UltraAimPoint> umps = new ArrayList<UltraAimPoint>();
            List<Double> angles = this.getEstimatedCorrectedHeading();
            for (Double correction : angles) {
                umps.add(new UltraAimPoint(this, BotTrigo.getPosition(this, (double)correction, this.getTraveledDistance(time)), correction));
            }
            return umps;
        }

        public String getOwner() {
            return this.owner;
        }

        public boolean isActive() {
            return this.isActive;
        }

        public void setInactive() {
            this.isActive = false;
        }

        public double getHeading() {
            return this.heading;
        }

        public double getVelocity() {
            return 20.0 - 3.0 * this.getPower();
        }

        public double getTraveledDistance(long time) {
            return this.getVelocity() * (double)(time - this.fireTime);
        }

        public double getPower() {
            return this.power;
        }
    }

    public static class UltraCorrection {
        public double correctionAngle;
        public int nbHit = 0;
        public long addTime = 0L;

        public UltraCorrection(double d, long time) {
            this.correctionAngle = d;
            this.addTime = time;
        }
    }
}

