/*
 * Decompiled with CFR 0.152.
 */
package cf.util;

import java.awt.Point;
import java.awt.geom.Point2D;
import robocode.AdvancedRobot;
import robocode.util.Utils;

public class Calc {
    public static double normalRelativeAngle(double angle) {
        return Math.toDegrees(Utils.normalRelativeAngle((double)Math.toRadians(angle)));
    }

    public static double sqr(double x) {
        return x * x;
    }

    public static double getKillPower(double enemyPower) {
        if (enemyPower > 3.96) {
            return enemyPower / 4.0;
        }
        return (enemyPower - 2.0) / 6.0;
    }

    public static double angleTo(double x, double y, AdvancedRobot bot) {
        return Math.toDegrees(1.5707963267948966 - Math.atan2(y - bot.getY(), x - bot.getX()));
    }

    public static void setGoto(AdvancedRobot bot, double x, double y) {
        double dist = Math.sqrt(Calc.sqr(bot.getX() - x) + Calc.sqr(bot.getY() - y));
        double ang = Calc.normalRelativeAngle(Calc.angleTo(x, y, bot) - bot.getHeading());
        if (Math.abs(ang) > 90.0) {
            dist *= -1.0;
            ang = ang > 0.0 ? (ang -= 180.0) : (ang += 180.0);
        }
        bot.setTurnRight(ang);
        bot.setAhead(dist);
    }

    public static void setGoto(AdvancedRobot bot, Point2D.Double p) {
        Calc.setGoto(bot, p.getX(), p.getY());
    }

    public static final void setGoto(AdvancedRobot bot, Point p) {
        Calc.setGoto(bot, p.getX(), p.getY());
    }

    public static void setGotoRandom(AdvancedRobot bot, Point p) {
        Calc.setGotoRandom(bot, p.getX(), p.getY());
    }

    public static void setGotoRandom(AdvancedRobot bot, Point2D.Double p) {
        Calc.setGotoRandom(bot, p.getX(), p.getY());
    }

    public static void setGotoRandom(AdvancedRobot bot, double x, double y) {
        double dist = Math.sqrt(Calc.sqr(bot.getX() - x) + Calc.sqr(bot.getY() - y));
        double ang = Calc.normalRelativeAngle(Calc.angleTo(x, y, bot) - bot.getHeading());
        if (Math.abs(ang) > 90.0) {
            dist *= -1.0;
            ang = ang > 0.0 ? (ang -= 180.0) : (ang += 180.0);
        }
        if (dist > 100.0) {
            ang += Math.random() * 40.0 - 20.0;
        }
        bot.setTurnRight(ang);
        bot.setAhead(dist);
    }

    public static void setGotoWin(AdvancedRobot bot, double x, double y) {
        double dist = Math.sqrt(Calc.sqr(bot.getX() - x) + Calc.sqr(bot.getY() - y));
        double ang = Calc.normalRelativeAngle(Calc.angleTo(x, y, bot) - bot.getHeading());
        if (Math.abs(ang) > 90.0) {
            dist *= -1.0;
            ang = ang > 0.0 ? (ang -= 180.0) : (ang += 180.0);
        }
        bot.setTurnRight(ang);
        double gunAngle = ang + bot.getHeading() - bot.getGunHeading();
        if (Math.random() < 0.5) {
            gunAngle *= -1.0;
        }
        gunAngle = Calc.normalRelativeAngle(gunAngle);
        bot.setTurnGunRight(gunAngle);
        bot.setTurnRadarRight(ang + bot.getHeading() - bot.getRadarHeading());
        bot.setAhead(dist);
    }

    public static double angle(double xDiff, double yDiff) {
        return Math.toDegrees(Math.atan2(xDiff, yDiff));
    }

    public static double travelTime(double dist, double power) {
        return dist / (20.0 - 3.0 * power);
    }

    public static double bulletSpeed(double power) {
        return 20.0 - 3.0 * power;
    }

    public static double distPoints(Point2D.Double p1, Point2D.Double p2) {
        return Math.pow(Math.pow(p1.getX() - p2.getX(), 2.0) + Math.pow(p1.getY() - p2.getY(), 2.0), 0.5);
    }

    public static double distPoints(Point p1, Point p2) {
        return Math.pow(Math.pow(p1.getX() - p2.getX(), 2.0) + Math.pow(p1.getY() - p2.getY(), 2.0), 0.5);
    }

    public static double dist(double x1, double y1, double x2, double y2) {
        return Math.pow(Math.pow(x1 - x2, 2.0) + Math.pow(y1 - y2, 2.0), 0.5);
    }

    public static Point2D.Double ePosition(double eAbsBear, double robotX, double robotY, double dist) {
        Point2D.Double ePos = new Point2D.Double();
        double ePosX = robotX + dist * Math.sin(Math.toRadians(eAbsBear));
        double ePosY = robotY + dist * Math.cos(Math.toRadians(eAbsBear));
        ePos.setLocation(ePosX, ePosY);
        return ePos;
    }

    public static Point getPoint(Point startPoint, double angle, double dist) {
        double x = startPoint.getX();
        double y = startPoint.getY();
        Point2D.Double returnV = Calc.ePosition(angle, x, y, dist);
        return new Point((int)returnV.getX(), (int)returnV.getY());
    }
}

