/*
 * Decompiled with CFR 0.152.
 */
package simonton.core;

import robocode.AdvancedRobot;
import robocode.Bullet;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.DeathEvent;
import robocode.Event;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.WinEvent;
import simonton.core.Bot;
import simonton.core.BulletWrapper;
import simonton.core.SlaveBot;
import simonton.core.Synchronizer;

public class SelfSynchronizer
extends Synchronizer {
    private DeathEvent blackness;
    private WinEvent hooray;
    private SkippedTurnEvent skip;
    private HitRobotEvent slam;
    private HitRobotEvent slammed;
    private HitWallEvent bang;
    private HitByBulletEvent burn;
    private BulletMissedEvent miss;
    private BulletHitEvent hit;
    private BulletHitBulletEvent cross;
    private ScannedRobotEvent scan;
    private RobotDeathEvent seeYa;

    public SelfSynchronizer(Bot master, SlaveBot slave) {
        super(master, slave);
    }

    public void moveLikeHim() {
        this.runIteration();
        this.master.setTurnRightRadians(this.slave.getTurnRemainingRadians());
        this.master.setMaxVelocity(this.slave.getMaxVelocity());
        this.master.setAhead(this.slave.getDistanceRemaining());
    }

    public Bullet shootLikeHim() {
        this.runIteration();
        Bullet bullet = null;
        BulletWrapper wrapper = this.slave.pollBulletWrapper();
        if (wrapper != null) {
            bullet = this.master.setFireBullet(wrapper.getPower());
            assert (bullet != null);
        }
        this.master.setTurnGunRightRadians(this.slave.getGunTurnRemainingRadians());
        return bullet;
    }

    public void handleDeathEvent(AdvancedRobot bot, DeathEvent e) {
        this.onDeath(e);
        for (Event e2 : bot.getAllEvents()) {
            if (e2 instanceof SkippedTurnEvent) {
                this.onSkippedTurn((SkippedTurnEvent)e2);
                continue;
            }
            if (e2 instanceof BulletMissedEvent) {
                this.onBulletMissed((BulletMissedEvent)e2);
                continue;
            }
            if (e2 instanceof BulletHitBulletEvent) {
                this.onBulletHitBullet((BulletHitBulletEvent)e2);
                continue;
            }
            if (e2 instanceof BulletHitEvent) {
                this.onBulletHit((BulletHitEvent)e2);
                continue;
            }
            if (e2 instanceof HitRobotEvent) {
                this.onHitRobot((HitRobotEvent)e2);
                continue;
            }
            if (e2 instanceof HitWallEvent) {
                this.onHitWall((HitWallEvent)e2);
                continue;
            }
            if (e2 instanceof HitByBulletEvent) {
                this.onHitByBullet((HitByBulletEvent)e2);
                continue;
            }
            if (!(e2 instanceof ScannedRobotEvent)) continue;
            this.onScannedRobot((ScannedRobotEvent)e2);
        }
        this.runIteration();
    }

    @Override
    public void runIteration() {
        this.slave.setGunTurnRemainingRadians(this.master.getGunTurnRemainingRadians());
        this.slave.setTurnRemainingRadians(this.master.getTurnRemainingRadians());
        this.slave.setDistanceRemaining(this.master.getDistanceRemaining());
        this.slave.setGunHeadingRadians(this.master.getGunHeadingRadians());
        this.slave.setHeadingRadians(this.master.getHeadingRadians());
        this.slave.setVelocity(this.master.getVelocity());
        this.slave.setGunHeat(this.master.getGunHeat());
        this.slave.setEnergy(this.master.getEnergy());
        this.slave.setTime(this.master.getTime());
        this.slave.setX(this.master.getX());
        this.slave.setY(this.master.getY());
        if (this.blackness != null) {
            this.slave.onDeath(this.blackness);
            this.blackness = null;
        }
        if (this.hooray != null) {
            this.slave.onWin(this.hooray);
            this.hooray = null;
        }
        if (this.skip != null) {
            this.slave.onSkippedTurn(this.skip);
            this.skip = null;
        }
        this.slave.doCustomEvents();
        if (this.seeYa != null) {
            this.slave.onRobotDeath(this.seeYa);
            this.seeYa = null;
        }
        if (this.miss != null) {
            this.slave.onBulletMissed(this.miss);
            this.miss = null;
        }
        if (this.cross != null) {
            this.slave.onBulletHitBullet(this.cross);
            this.cross = null;
        }
        if (this.hit != null) {
            this.slave.onBulletHit(this.hit);
            this.hit = null;
        }
        if (this.slam != null) {
            this.slave.onHitRobot(this.slam);
            this.slam = null;
        }
        if (this.slammed != null) {
            this.slave.onHitRobot(this.slammed);
            this.slammed = null;
        }
        if (this.bang != null) {
            this.slave.onHitWall(this.bang);
            this.bang = null;
        }
        if (this.burn != null) {
            this.slave.onHitByBullet(this.burn);
            this.burn = null;
        }
        if (this.scan != null) {
            this.slave.onScannedRobot(this.scan);
            this.scan = null;
        }
        this.slave.runIteration();
    }

    @Override
    public void onHitRobot(HitRobotEvent e) {
        if (e.isMyFault()) {
            this.slam = e;
        } else {
            this.slammed = e;
        }
    }

    @Override
    public void onDeath(DeathEvent e) {
        this.blackness = e;
    }

    @Override
    public void onWin(WinEvent e) {
        this.hooray = e;
    }

    @Override
    public void onBulletHit(BulletHitEvent e) {
        this.hit = e;
    }

    @Override
    public void onBulletHitBullet(BulletHitBulletEvent e) {
        this.cross = e;
    }

    @Override
    public void onBulletMissed(BulletMissedEvent e) {
        this.miss = e;
    }

    @Override
    public void onHitByBullet(HitByBulletEvent e) {
        this.burn = e;
    }

    @Override
    public void onHitWall(HitWallEvent e) {
        this.bang = e;
    }

    @Override
    public void onScannedRobot(ScannedRobotEvent e) {
        this.scan = e;
    }

    @Override
    public void onSkippedTurn(SkippedTurnEvent e) {
        this.slave.onSkippedTurn(e);
    }

    @Override
    public void onRobodDeath(RobotDeathEvent e) {
        this.seeYa = e;
    }
}

