/*
 * Decompiled with CFR 0.152.
 */
package simonton.movements;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.PriorityQueue;
import robocode.HitRobotEvent;
import robocode.ScannedRobotEvent;
import simonton.core.Bot;
import simonton.core.SlaveBot;
import simonton.movements.Destination;
import simonton.movements.Path;
import simonton.utils.FastMath;
import simonton.utils.Location;
import simonton.utils.Util;
import simonton.waves.EnemyWaveManager;
import simonton.waves.GFProbability;
import simonton.waves.Wave;
import simonton.waves.WaveStatistician;

public class PathSurfer
extends SlaveBot {
    private static final double TARGET_DISTANCE = 500.0;
    private static final double ATTACK_FACTOR = 0.39269908169872414;
    private static final double RETREAT_FACTOR = 0.5890486225480862;
    private static final int GF_ZERO = 15;
    private static final int POINTS_PER_WAVE = 31;
    private static final double MAX_ATTACK = 0.7853981633974483;
    private EnemyWaveManager waveManager;
    private Path curPath;
    private Location orbitLoc;
    private int retreatOrientation;
    private boolean impossible = false;
    private Driver predict;
    private Driver lastState;

    public PathSurfer(WaveStatistician statistician) {
        this.waveManager = new EnemyWaveManager(statistician);
        this.keepSynchronized(true, this.waveManager);
    }

    @Override
    public void run() {
        super.run();
        this.curPath = null;
        this.predict = null;
    }

    @Override
    public void runIteration() {
        super.runIteration();
        if (this.hisLoc == null) {
            return;
        }
        this.myLoc = new Location(this);
        boolean recalc = false;
        if (!(this.predict == null || FastMath.equal(this.predict.getVelocity(), this.getVelocity()) && FastMath.equal(FastMath.normalize(this.predict.getHeadingRadians() - this.getHeadingRadians()), 0.0))) {
            Util.log("Predict:", new Object[0]);
            this.printPredict(this.predict);
            Util.log("LastState:", new Object[0]);
            this.printPredict(this.lastState);
            recalc = true;
        }
        if (this.waveManager.changed() || recalc || this.curPath == null || this.curPath.getFirstDestination().deadline <= this.getTime()) {
            List flyingWaves = this.waveManager.getApproachingWaves(false);
            this.orbitLoc = flyingWaves.size() > 0 ? this.waveManager.getMostRecentWave().origin : this.hisLoc;
            this.curPath = new Path(this, flyingWaves);
            PriorityQueue<Path> paths = new PriorityQueue<Path>();
            while (this.curPath.canAdvance(flyingWaves)) {
                paths.poll();
                for (Path path : this.advance(this.curPath, flyingWaves)) {
                    paths.offer(path);
                }
                this.curPath = (Path)paths.peek();
            }
        } else {
            this.waveManager.offtick();
        }
        Driver driver = new Driver(this);
        if (this.curPath.points.size() == 1) {
            driver.goTo(this.pickRetreatPoint(), Long.MAX_VALUE, null);
        } else {
            Destination dest = (Destination)this.curPath.points.get(1);
            if (this.curPath.points.size() == 2) {
                driver.goTo(dest, dest.deadline, null);
            } else {
                driver.goTo(dest, dest.deadline, (Point2D.Double)this.curPath.points.get(2));
            }
        }
        this.setAhead(driver.getDistanceRemaining());
        this.setMaxVelocity(driver.getMaxVelocity());
        this.setTurnRightRadians(driver.getTurnRemainingRadians());
        this.lastState = new Driver(this);
        this.lastState.setDistanceRemaining(this.getDistanceRemaining());
        this.lastState.setTurnRightRadians(this.getTurnRemainingRadians());
        this.lastState.setMaxVelocity(this.getMaxVelocity());
        this.predict = new Driver(this);
        this.predict.setDistanceRemaining(this.getDistanceRemaining());
        this.predict.setTurnRightRadians(this.getTurnRemainingRadians());
        this.predict.setMaxVelocity(this.getMaxVelocity());
        this.predict.tick();
    }

    public Collection advance(Path path, Collection flyingWaves) {
        Destination lastPoint = path.getLastDestination();
        Wave wave = path.getNextWave(flyingWaves);
        path.pendingWaves.remove(wave);
        Collection gotoPoints = this.getGotoPoints(lastPoint, wave);
        if (gotoPoints.isEmpty()) {
            path.unreachableWaves.add(wave);
            path.addDanger(wave, lastPoint);
            return Collections.singleton(path);
        }
        ArrayList<Path> nextPaths = new ArrayList<Path>();
        for (Destination point : gotoPoints) {
            nextPaths.add(new Path(path, point));
        }
        return nextPaths;
    }

    public Collection getGotoPoints(Destination startPoint, Wave wave) {
        Destination point;
        double dToOrigin = startPoint.distance(wave.origin);
        double dToOrbit = startPoint.distance(this.orbitLoc);
        double aFromOrigin = wave.origin.bearing(startPoint);
        double aFromOrbit = this.orbitLoc.bearing(startPoint);
        ArrayList<Destination> points = new ArrayList<Destination>();
        GFProbability[] localMins = wave.getMinimumProbabilities(31, wave.getGFBotwidth(1.0, dToOrigin));
        int curMin = wave.getFactorIndex(startPoint, 15, 0);
        int i = curMin = FastMath.bound(curMin, 0, 30);
        while (i < localMins.length) {
            point = this.getGotoPoint(startPoint, localMins[i], dToOrigin, dToOrbit, aFromOrigin, aFromOrbit);
            if (point != null) {
                points.add(point);
            } else if (this.impossible) {
                this.impossible = false;
                break;
            }
            ++i;
        }
        i = curMin;
        while (--i >= 0) {
            point = this.getGotoPoint(startPoint, localMins[i], dToOrigin, dToOrbit, aFromOrigin, aFromOrbit);
            if (point != null) {
                points.add(point);
                continue;
            }
            if (!this.impossible) continue;
            this.impossible = false;
            break;
        }
        return points;
    }

    private Destination getGotoPoint(Destination startPoint, GFProbability safety, double dToOrigin, double dToOrbit, double aFromOrigin, double aFromOrbit) {
        double idealTravelAngle = aFromOrbit + 1.5707963267948966;
        double circularAdjust = FastMath.normalize(safety.angle - aFromOrigin) / 2.0;
        idealTravelAngle += circularAdjust;
        double retreatAdjust = this.getRetreatAngle(dToOrbit);
        idealTravelAngle = FastMath.normalize(safety.angle - aFromOrbit) > 0.0 ? (idealTravelAngle -= retreatAdjust) : (idealTravelAngle += retreatAdjust);
        double A = safety.angle - aFromOrigin;
        double B = Math.PI - (idealTravelAngle - aFromOrigin);
        double C = Math.PI - A - B;
        double c = dToOrigin;
        double a = c * FastMath.sin(A) / FastMath.sin(C);
        Location dest = Util.project((Point2D.Double)startPoint, a, idealTravelAngle);
        Util.inBound(dest, 30.0, safety.angle);
        double distFromWave = safety.wave.origin.distance(dest);
        int deadline = safety.wave.impactTime(distFromWave) - 1;
        if (startPoint.arrivalTime >= (long)deadline) {
            return null;
        }
        if (startPoint.distance(dest) / (double)((long)deadline - this.getTime()) > 8.0) {
            this.impossible = true;
            return null;
        }
        Driver futureBot = new Driver(startPoint);
        while (futureBot.getTime() < startPoint.deadline) {
            futureBot.goTo(new Location(futureBot), startPoint.deadline, dest);
            futureBot.tick();
        }
        futureBot.goTo(dest, deadline, null);
        while (!futureBot.reachedDest(deadline) && futureBot.getTime() <= (long)deadline) {
            futureBot.tick();
            futureBot.goTo(dest, deadline, null);
        }
        int predictTime = (int)futureBot.getTime();
        if (predictTime > deadline) {
            return null;
        }
        Destination endPoint = new Destination(dest, deadline, predictTime, futureBot.getHeadingRadians(), futureBot.getVelocity(), safety, distFromWave);
        return endPoint;
    }

    private double getRetreatAngle(double distance) {
        double adjMaxDist = 500.0 - Util.minDistance;
        double retreatAdjust = FastMath.bound((adjMaxDist - distance) / adjMaxDist, -1.0, 1.0);
        retreatAdjust = retreatAdjust > 0.0 ? (retreatAdjust *= 0.5890486225480862) : (retreatAdjust *= 0.39269908169872414);
        return retreatAdjust;
    }

    private void printPredict(Driver predict) {
        Util.log("%10f%10s%10f", new Object[]{predict.getHeadingRadians(), "heading", this.getHeadingRadians()});
        Util.log("%10f%10s%10f", new Object[]{predict.getTurnRemainingRadians(), "turn", this.getTurnRemainingRadians()});
        Util.log("%10f%10s%10f", new Object[]{predict.getVelocity(), "velocity", this.getVelocity()});
        Util.log("%10f%10s%10f", new Object[]{predict.getMaxVelocity(), "max", this.getMaxVelocity()});
        Util.log("%10f%10s%10f", new Object[]{predict.getDistanceRemaining(), "distance", this.getDistanceRemaining()});
    }

    @Override
    public void onScannedRobot(ScannedRobotEvent e) {
        super.onScannedRobot(e);
    }

    public static double getTurn(double startAngle, double endAngle) {
        double turn = FastMath.normalize(endAngle - startAngle);
        if (turn < -1.5707963267948966) {
            turn += Math.PI;
        } else if (turn > 1.5707963267948966) {
            turn -= Math.PI;
        }
        return turn;
    }

    private Point2D.Double pickRetreatPoint() {
        double retreatAdjust;
        double bearing;
        Location retreat;
        if (this.getTime() < 30L && FastMath.equal(this.getVelocity(), 0.0)) {
            double myAngle = Util.bearing(Util.centerPoint, this.hisLoc);
            double hisAngle = Util.bearing(Util.centerPoint, this.myLoc);
            double myDistance = Util.centerPoint.distance(this.myLoc);
            double hisDistance = Util.centerPoint.distance(this.hisLoc);
            this.retreatOrientation = FastMath.sign(FastMath.normalize(hisAngle - myAngle)) * FastMath.sign(myDistance - hisDistance);
        }
        if (Util.inBound(retreat = Util.project((Point2D.Double)this.myLoc, 30.0, (bearing = Util.bearing(this.hisLoc, this.myLoc)) + (retreatAdjust = (double)this.retreatOrientation * (1.5707963267948966 - this.getRetreatAngle(this.myLoc.distance(this.hisLoc))))), 30.0)) {
            retreat = Util.project((Point2D.Double)this.myLoc, 30.0, bearing - retreatAdjust);
            if (Util.inBound(retreat, 30.0)) {
                retreat = Util.project((Point2D.Double)this.myLoc, 30.0, bearing + retreatAdjust);
                Util.inBound(retreat, 30.0);
            } else {
                this.retreatOrientation = -this.retreatOrientation;
            }
        }
        return retreat;
    }

    @Override
    public void onHitRobot(HitRobotEvent e) {
        super.onHitRobot(e);
        if (e.isMyFault()) {
            this.retreatOrientation = -this.retreatOrientation;
        }
    }

    @Override
    public void onPaint(Graphics2D g) {
        g.setColor(Color.WHITE);
        Location loc = new Location(this);
        double heading = this.getHeadingRadians();
        Util.paintCircle(g, loc, 10.0, false);
        Util.paintLine(g, (Point2D.Double)Util.project((Point2D.Double)loc, 20.0, heading), Util.project((Point2D.Double)loc, -20.0, heading));
        double distance = 0.0;
        if (this.curPath != null) {
            this.curPath.onPaint(g, this.getTime());
            if (this.curPath.points.size() > 1) {
                distance = this.myLoc.distance((Point2D)this.curPath.points.get(1));
            } else {
                g.setColor(Color.GREEN);
                Util.paintCircle(g, this.pickRetreatPoint(), 5.0, true);
            }
        }
        g.setColor(Color.WHITE);
        g.drawString(String.format("%.2f", this.getVelocity()), (float)this.getX() + 30.0f, (float)this.getY() + 12.0f);
        g.drawString("" + this.getTime(), (float)this.getX() + 30.0f, (float)this.getY());
        g.drawString(String.format("%.2f", distance), (float)this.getX() + 30.0f, (float)this.getY() - 12.0f);
        if (this.hisLoc != null) {
            g.drawString(String.format("%.2f", this.myLoc.distance(this.hisLoc)), (float)this.hisLoc.x + 30.0f, (float)this.hisLoc.y - 6.0f);
        }
        super.onPaint(g);
    }

    public class Driver
    extends SlaveBot {
        private double targetDistance;
        private double lastHeading;
        private Point2D.Double lastDest;
        private boolean safeToTryUsingLast;
        final PathSurfer this$0;

        public void goTo(Point2D.Double dest, long deadline, Point2D.Double next) {
            double turn;
            double distance;
            double velocity = this.getVelocity();
            Location myLoc = new Location(this);
            double heading = this.getHeadingRadians();
            boolean useLast = FastMath.equal(this.lastHeading, heading) && this.safeToTryUsingLast && this.lastDest != null && this.lastDest.equals(dest);
            this.safeToTryUsingLast = true;
            if (useLast) {
                distance = this.targetDistance - velocity;
                turn = this.getTurnRemainingRadians();
            } else {
                distance = myLoc.distance(dest);
                if (FastMath.equal(distance, 0.0)) {
                    if (next == null) {
                        turn = 0.0;
                    } else {
                        turn = PathSurfer.getTurn(this.getHeadingRadians(), Util.bearing(dest, next));
                        if (FastMath.abs(velocity) <= 2.0 && 0.17453292519943295 * (double)(deadline - this.getTime()) >= FastMath.abs(turn)) {
                            this.safeToTryUsingLast = false;
                            turn = 0.0;
                        }
                    }
                } else {
                    turn = FastMath.normalize(Util.bearing(myLoc, dest) - heading);
                    if (turn < -1.5707963267948966) {
                        turn += Math.PI;
                        distance = -distance;
                    } else if (turn > 1.5707963267948966) {
                        turn -= Math.PI;
                        distance = -distance;
                    }
                }
            }
            this.setTurnRightRadians(turn);
            this.lastDest = dest;
            this.targetDistance = distance;
            this.lastHeading = heading;
            if (FastMath.equal(distance, 0.0)) {
                this.setAhead((double)(this.getTime() % 2L) - 0.5);
                this.setMaxVelocity(1.0E-10);
            } else if (velocity <= 0.0 != distance <= 0.0) {
                this.setAhead(distance);
                this.setMaxVelocity(8.0);
            } else {
                double max;
                this.setAhead(distance * Double.POSITIVE_INFINITY);
                distance = FastMath.abs(distance);
                double t = deadline - this.getTime();
                if (distance <= 2.0) {
                    max = distance;
                } else if (distance >= 20.0) {
                    max = 8.0;
                } else if (t > 0.0 && t * (t + 1.0) < distance) {
                    max = distance / t + (t - 1.0);
                } else {
                    int n = 2 * FastMath.ceil(distance / 2.0 - 1.0E-5);
                    double s = (int)Math.sqrt(4 * n + 1) - 1;
                    max = distance + s - (double)n;
                }
                this.setMaxVelocity(max + 1.8 * (1.0 - FastMath.square(1.0 + FastMath.abs(turn))));
            }
        }

        public boolean reachedDest(long deadline) {
            return FastMath.equal(this.targetDistance, 0.0) && (this.getTime() == deadline || Math.abs(this.getVelocity()) < 2.00001);
        }

        public void onPaint(Graphics2D g, Point2D.Double loc, int offset) {
            float x = (float)loc.getX();
            float y = (float)loc.getY() + (float)offset;
            g.setColor(Color.WHITE);
            g.drawString(String.format("%.2f", this.getVelocity()), x, y - 6.0f);
            g.drawString("" + this.getTime(), x, y - 18.0f);
            g.drawString(String.format("%.2f", this.targetDistance), x, y - 30.0f);
        }

        public Driver(Bot startState) {
            this.this$0 = PathSurfer.this;
            this.lastHeading = 0.0;
            this.lastDest = null;
            this.safeToTryUsingLast = true;
            this.setTime(startState.getTime());
            this.setX(startState.getX());
            this.setY(startState.getY());
            this.setVelocity(startState.getVelocity());
            this.setHeadingRadians(startState.getHeadingRadians());
        }

        public Driver(Destination startState) {
            this.this$0 = PathSurfer.this;
            this.lastHeading = 0.0;
            this.lastDest = null;
            this.safeToTryUsingLast = true;
            this.setTime(startState.arrivalTime);
            this.setX(startState.x);
            this.setY(startState.y);
            this.setVelocity(startState.arrivalSpeed);
            this.setHeadingRadians(startState.arrivalAngle);
        }

        public Driver(Driver d) {
            this((Bot)d);
            this.targetDistance = d.targetDistance;
            this.lastHeading = d.lastHeading;
            this.lastDest = d.lastDest;
        }
    }
}

