/*
 * Decompiled with CFR 0.152.
 */
package Krabb.krabby;

import Krabb.krabby.Aim;
import Krabb.krabby.AvarageExponential;
import Krabb.krabby.Circular;
import Krabb.krabby.Constants;
import Krabb.krabby.Enemy;
import Krabb.krabby.Exponential;
import Krabb.krabby.Linear;
import Krabb.krabby.Punctiform;
import Krabb.krabby.Random;
import Krabb.krabby.Rifle;
import Krabb.krabby.Simulation;
import Krabb.krabby.Statistics;
import robocode.AdvancedRobot;
import robocode.util.Utils;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
class Gun
implements Constants {
    private static Statistics statistics = new Statistics();
    private int bestaim;
    private Simulation simulation;
    private Aim aim;
    private Rifle[] rifle;

    public void RoundEnd(AdvancedRobot r, Enemy e) {
        statistics.printStats();
        this.simulation.removeAllWaves();
        if (r.getRoundNum() == r.getNumRounds() - 1) {
            statistics.writeStats(r, e);
        }
    }

    public void Step(Enemy e, AdvancedRobot r) {
        int x = 0;
        while (x < 6) {
            this.rifle[x].Step(r, e);
            ++x;
        }
        this.simulation.Step(r, e, r.getTime(), statistics);
        this.aim(r, e);
        if ((int)Math.abs(Utils.normalRelativeAngle((double)(this.aim.a - r.getGunHeadingRadians()))) == 0) {
            this.fire(r, e);
        }
    }

    public Aim aim(AdvancedRobot r, Enemy e) {
        double p = Gun.setPower(r, e);
        this.aim = this.rifle[statistics.getBestAim(r, e)].aim(r, e, p);
        r.setTurnGunRightRadians(Utils.normalRelativeAngle((double)(this.aim.a - r.getGunHeadingRadians())));
        return this.aim;
    }

    public void fire(AdvancedRobot r, Enemy e) {
        this.aim.p = Gun.setPower(r, e);
        if (r.getGunHeat() > 0.0 || r.getEnergy() <= 0.1 || this.aim.p < 0.1) {
            return;
        }
        r.setFire(this.aim.p);
        int currentwave = this.simulation.fire(r, this.aim, statistics);
        if (currentwave < 0) {
            return;
        }
        double dx = e.getX() - r.getX();
        double dy = e.getY() - r.getY();
        double d = Math.sqrt(dx * dx + dy * dy);
        int x = 0;
        while (x < 6) {
            double a = this.rifle[x].aim((AdvancedRobot)r, (Enemy)e, (double)this.aim.p).a;
            this.simulation.wave[currentwave].addBullet(a, x);
            ++x;
        }
    }

    static double setPower(AdvancedRobot r, Enemy e) {
        double p = Math.max(0.1, Math.min((double)3, -0.004 * e.getD() + (double)4));
        return Math.min(e.getL() / (double)4 + 0.1, p);
    }

    private final /* synthetic */ void this() {
        this.bestaim = 0;
        this.simulation = new Simulation();
        this.aim = new Aim();
        this.rifle = new Rifle[6];
    }

    Gun(AdvancedRobot r, Enemy e) {
        this.this();
        if (r.getRoundNum() == 0) {
            statistics.readStats(r, e);
        }
        this.rifle[0] = new Punctiform();
        this.rifle[1] = new Exponential();
        this.rifle[2] = new Linear();
        this.rifle[3] = new Circular();
        this.rifle[4] = new Random();
        this.rifle[5] = new AvarageExponential();
    }
}

