/*
 * Decompiled with CFR 0.152.
 */
package cbot.cbot.gun;

import cbot.cbot.CU;
import cbot.cbot.gun.Move;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Pattern {
    private Move[] trackList;
    private StringBuffer track;
    private int MAX_TRACK;
    private int MIN_TRACK_LENGTH;
    private int trackLength;
    private long lastTime;
    private long totMatchLength;
    private int totMatches;
    private char[] hs;
    private char[] vs;

    public void log(long time, double headingDelta, double velocity, double velocityDelta) {
        this.trackList[this.trackLength++] = new Move(time, CU.normalRelativeAngle(headingDelta), velocity, velocityDelta);
        long timeDiff = time - this.lastTime;
        this.lastTime = time;
        headingDelta /= (double)timeDiff;
        velocity /= (double)timeDiff;
        headingDelta = Math.min(headingDelta, 10.0);
        headingDelta = Math.max(headingDelta, -10.0);
        velocity = Math.min(velocity, 8.0);
        velocity = Math.max(velocity, -8.0);
        int hDelta = (int)headingDelta + 10;
        int vIndex = (int)velocity + 8;
        this.track.append(this.hs[hDelta]).append(this.vs[vIndex]);
        if (this.trackLength == this.trackList.length - 1) {
            int removLength = (int)((double)this.MAX_TRACK * 0.1);
            this.track.replace(0, removLength * 2, "");
            Move[] tmp = new Move[this.MAX_TRACK];
            this.trackLength -= removLength;
            System.arraycopy(this.trackList, removLength - 1, tmp, 0, this.trackLength);
            this.trackList = tmp;
        }
    }

    public int getMatch() {
        int index = 0;
        int tmpIndex = 0;
        int patternStart = this.trackLength * 2;
        String pattern = "";
        while (tmpIndex != -1 && tmpIndex < this.trackLength * 2 - this.MIN_TRACK_LENGTH && patternStart > 0) {
            index = tmpIndex;
            if (this.trackLength * 2 - patternStart > 50) break;
            pattern = this.track.substring(patternStart -= 2);
            tmpIndex = this.track.toString().indexOf(pattern);
        }
        int patternLength = this.trackLength * 2 - patternStart;
        int trackPoint = (index + patternLength) / 2;
        ++this.totMatches;
        this.totMatchLength += (long)(patternLength / 2);
        return trackPoint;
    }

    public int size() {
        return this.trackLength;
    }

    public Move[] getArray() {
        return this.trackList;
    }

    public boolean ready() {
        boolean bl = false;
        if (this.trackLength > this.MIN_TRACK_LENGTH) {
            bl = true;
        }
        return bl;
    }

    public String getAvgPatternLength() {
        return CU.formatNumber((double)this.totMatchLength / (double)this.totMatches);
    }

    private final /* synthetic */ void this() {
        this.MAX_TRACK = 50000;
        this.MIN_TRACK_LENGTH = 60;
        this.trackLength = 0;
        this.lastTime = 0L;
        this.totMatchLength = 0L;
        this.totMatches = 0;
        this.hs = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u'};
        this.vs = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q'};
    }

    public Pattern() {
        this.this();
        this.trackList = new Move[this.MAX_TRACK];
        this.track = new StringBuffer();
    }
}

