/*
 * Decompiled with CFR 0.152.
 */
package shrub;

import java.text.NumberFormat;
import java.util.LinkedList;
import java.util.ListIterator;
import shrub.Bearing;
import shrub.Box;
import shrub.Movement;
import shrub.Sighting;

public class MoveHistory
extends LinkedList {
    private final int mMaxSize;
    private final String mName;
    private final Box mMovementArea;
    private static final NumberFormat dp2 = NumberFormat.getInstance();

    public MoveHistory(String name, int maxSize, Box movementArea) {
        this.mName = name;
        this.mMaxSize = maxSize;
        this.mMovementArea = movementArea;
    }

    public final String GetName() {
        return this.mName;
    }

    public final int GetMaxMoves() {
        return this.mMaxSize;
    }

    public final int GetNumMoves() {
        return this.size();
    }

    public final Movement GetLastNonEstimate() {
        Movement answer = null;
        boolean found = false;
        int listSize = this.size();
        ListIterator iterator = this.listIterator(listSize);
        while (!found && iterator.hasPrevious()) {
            Movement thisMove = (Movement)iterator.previous();
            if (thisMove.GetIsEstimate()) continue;
            answer = thisMove;
            found = true;
        }
        return answer;
    }

    private final boolean AddFirstSighting(Sighting newSighting) {
        Movement newMove = Movement.valueOfSighting(newSighting);
        this.AppendMovement(newMove);
        return true;
    }

    private final boolean AddSubsequentSighting(Sighting newSighting) {
        boolean okSoFar = true;
        Movement oldSightingMove = this.GetLastNonEstimate();
        if (oldSightingMove == null) {
            System.out.println("ERROR: MoveHistory.AddSubsequentSighting, no previous sighting of [" + this.mName + "]");
            okSoFar = false;
        } else {
            long newSightTime = newSighting.GetTimestamp();
            long oldSightTime = oldSightingMove.GetTimeNow();
            long sightTimeDelta = newSightTime - oldSightTime;
            Movement lastMove = (Movement)this.getLast();
            long lastMoveTime = lastMove.GetTimeNow();
            long moveTimeDelta = newSightTime - lastMoveTime;
            if (sightTimeDelta <= 0L) {
                System.out.println("ERROR: MoveHistory, new sighting prior to old sighting!");
                okSoFar = false;
            } else if (moveTimeDelta <= 0L) {
                System.out.println("ERROR: MoveHistory, new sighting prior to estimate!");
                okSoFar = false;
            } else {
                Bearing hdngDelta = Bearing.valueOfFromTo(oldSightingMove.GetHdngNow(), newSighting.GetHeading());
                double avgeHdngDelta = hdngDelta.Get() / (double)sightTimeDelta;
                Bearing hdngDeltaAvge = Bearing.valueOf(avgeHdngDelta);
                Movement newMove = Movement.valueOfSightingPlus(newSighting, hdngDeltaAvge, moveTimeDelta);
                this.AppendMovement(newMove);
            }
        }
        return okSoFar;
    }

    public final boolean ReportSighting(Sighting newSighting) {
        boolean success = false;
        long newMoveTime = newSighting.GetTimestamp();
        if (this.size() <= 0) {
            this.AddFirstSighting(newSighting);
        } else {
            success = this.AddSubsequentSighting(newSighting);
        }
        return success;
    }

    public final boolean Extrapolate(long timeNow) {
        boolean extrapolated = false;
        if (this.size() <= 0) {
            System.out.println("Cannot extrapolate, no sighting yet");
        } else {
            Movement lastMove = (Movement)this.getLast();
            Movement extrapMove = Movement.valueOfExtrapolation(lastMove, timeNow, this.mMovementArea, null);
            if (extrapMove != null) {
                this.AppendMovement(extrapMove);
            }
        }
        return extrapolated;
    }

    public void AppendMovement(Movement newMove) {
        this.addLast(newMove);
        this.TruncateListStart();
    }

    private void TruncateListStart() {
        int sizeNow = this.size();
        while (sizeNow > this.mMaxSize) {
            this.removeFirst();
            sizeNow = this.size();
        }
    }

    public final Movement GetLastMove() {
        Movement lastMove = null;
        if (this.size() > 0) {
            lastMove = (Movement)this.getLast();
        }
        return lastMove;
    }

    public boolean IsEmpty() {
        boolean answer = false;
        if (this.size() <= 0) {
            answer = true;
        }
        return answer;
    }

    public double GetEnergyDelta(long toTime) {
        double energyDelta = 0.0;
        int listSize = this.size();
        if (listSize < 2) {
            System.out.println("Need >=2 sightings to determine energy delta!");
        } else {
            ListIterator iterator = this.listIterator(listSize);
            Movement lastMove = (Movement)iterator.previous();
            boolean lastIsEst = lastMove.GetIsEstimate();
            long lastTime = lastMove.GetTimeNow();
            if (lastTime == toTime && !lastIsEst) {
                Movement prevMove = (Movement)iterator.previous();
                boolean prevIsEst = prevMove.GetIsEstimate();
                long prevTime = prevMove.GetTimeNow();
                long deltaTime = lastTime - prevTime;
                if (deltaTime == 1L && !prevIsEst) {
                    double lastEnergy = lastMove.GetEnergyNow();
                    double prevEnergy = prevMove.GetEnergyNow();
                    energyDelta = lastEnergy - prevEnergy;
                }
            }
        }
        return energyDelta;
    }

    public void Print() {
        System.out.println("===== MoveHistory =====");
        System.out.println(" mName: " + this.mName);
        System.out.print(" mMaxSize: " + this.mMaxSize);
        System.out.print(" mSizeNow: " + this.size());
        System.out.println();
    }

    static {
        dp2.setMaximumFractionDigits(2);
        dp2.setMinimumFractionDigits(2);
    }
}

