/*
 * Decompiled with CFR 0.152.
 */
package shrub;

import shrub.Bearing;
import shrub.Heading;
import shrub.RadarInstruction;
import shrub.RadarModeAPI;
import shrub.RobotDataStore;

public class RadarModeTOH
implements RadarModeAPI {
    private Heading mTargetHdng = Heading.ZERO;
    private final double mScanSpeed;
    private final double mScanPastAngle;
    private final RobotDataStore mDataStore = RobotDataStore.getInstance();

    public RadarModeTOH(double scanSpeed, double scanPastAngle) {
        this.mScanSpeed = scanSpeed;
        this.mScanPastAngle = scanPastAngle;
    }

    public void SetTargetHdng(Heading targetHdng) {
        this.mTargetHdng = targetHdng;
    }

    public RadarInstruction GenerateInstruction() {
        Heading radarHdng = this.mDataStore.getMyRadarHdng();
        Bearing targetBearing = Bearing.valueOfFromTo(radarHdng, this.mTargetHdng);
        double amount = targetBearing.GetAbs() + this.mScanPastAngle;
        if (this.mScanSpeed < amount) {
            amount = this.mScanSpeed;
        }
        RadarInstruction instruct = null;
        instruct = targetBearing.IsAligned() ? RadarInstruction.valueOf(RadarInstruction.NONE, 0.0) : (targetBearing.IsLeftward() ? RadarInstruction.valueOf(RadarInstruction.LEFT, amount) : RadarInstruction.valueOf(RadarInstruction.RIGHT, amount));
        return instruct;
    }

    public void Resynchronise() {
    }
}

