/*
 * Decompiled with CFR 0.152.
 */
package wcsv.mega;

import java.awt.Color;
import java.awt.Graphics2D;
import robocode.AdvancedRobot;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.HitByBulletEvent;
import robocode.ScannedRobotEvent;
import robocode.TeamRobot;
import wcsv.mega.DamageTracker;
import wcsv.mega.Gun;
import wcsv.mega.Movement;
import wcsv.mega.MyInfo;
import wcsv.mega.PHGFGun;
import wcsv.mega.PHWaveSurfMove;
import wcsv.mega.Radar;
import wcsv.mega.ScanManager;

public class PowerHouse2
extends TeamRobot {
    public static boolean isDuel = true;
    private ScanManager scans;
    private MyInfo me;
    private Radar radar;
    private static Gun gun;
    private static Movement move;

    private void init() {
        DamageTracker.init();
        this.setColors(Color.blue.darker(), Color.red, Color.white);
        this.setAdjustRadarForGunTurn(true);
        this.setAdjustRadarForRobotTurn(true);
        this.setAdjustGunForRobotTurn(true);
        this.me = new MyInfo((AdvancedRobot)this);
        this.scans = new ScanManager(this.me);
        this.radar = new Radar(this.me);
        if (gun == null) {
            gun = new PHGFGun(this.me, this.scans);
        } else {
            gun.reset(this.me, this.scans);
        }
        if (move == null) {
            move = new PHWaveSurfMove(this.me, this.scans);
        } else {
            move.reset(this.me, this.scans);
        }
    }

    public void run() {
        this.init();
        while (true) {
            this.me.update();
            this.radar.lock(this.scans.last());
            gun.doGun(this.scans.last());
            move.doMove(this.scans.last());
            this.execute();
        }
    }

    public void onScannedRobot(ScannedRobotEvent e) {
        this.me.update();
        this.scans.add(e);
        gun.onScan(this.scans.last());
        move.onScan(this.scans.last());
    }

    public void onBulletHitBullet(BulletHitBulletEvent e) {
        move.onBulletHitBullet(e);
    }

    public void onHitByBullet(HitByBulletEvent e) {
        move.onHitByBullet(e);
        if (isDuel) {
            this.scans.last().last().madeBulletHit(e.getPower());
        }
    }

    public void onBulletHit(BulletHitEvent e) {
        if (isDuel) {
            this.scans.last().last().hitByBullet(e.getBullet().getPower());
        }
    }

    public void onPaint(Graphics2D g) {
        g.setColor(Color.red);
        if (move != null) {
            move.draw(g);
        }
    }
}

