/*
 * Decompiled with CFR 0.152.
 */
package labg.targeting;

import labg.targeting.TargetingStrategy;
import labg.util.Enemy;
import labg.util.Geometry;
import robocode.AdvancedRobot;
import robocode.BulletHitBulletEvent;
import robocode.BulletHitEvent;
import robocode.BulletMissedEvent;
import robocode.DeathEvent;
import robocode.HitByBulletEvent;
import robocode.HitRobotEvent;
import robocode.HitWallEvent;
import robocode.RobotDeathEvent;
import robocode.ScannedRobotEvent;
import robocode.SkippedTurnEvent;
import robocode.WinEvent;

public class TrackTargetingStrategy
extends TargetingStrategy {
    AdvancedRobot myBot;
    Enemy target;
    int turnDirec = 1;

    public TrackTargetingStrategy(AdvancedRobot myBot, Enemy target) {
        super(myBot);
        this.myBot = myBot;
        this.target = target;
    }

    public void target() {
        if (this.myBot.getTime() - this.target.timeLastSeen > 30L) {
            this.myBot.setTurnRadarRightRadians(Math.PI * 2);
        } else if (this.myBot.getRadarTurnRemaining() == 0.0) {
            double radarMovement = this.target.currBearing + (this.myBot.getHeadingRadians() - this.myBot.getRadarHeadingRadians());
            this.turnDirec *= -1;
            this.myBot.setTurnRadarRightRadians(Geometry.normaliseBearing(radarMovement + 0.7853981633974483 * (double)this.turnDirec));
        }
    }

    public void setEnemy(Enemy foe) {
        this.target = foe;
    }

    public Enemy getEnemy() {
        return this.target;
    }

    public void onScannedRobot(ScannedRobotEvent e) {
    }

    public void onHitByBullet(HitByBulletEvent e) {
    }

    public void onBulletHitBullet(BulletHitBulletEvent e) {
    }

    public void onBulletHit(BulletHitEvent e) {
    }

    public void onBulletMissed(BulletMissedEvent e) {
    }

    public void onDeath(DeathEvent e) {
    }

    public void onHitRobot(HitRobotEvent e) {
    }

    public void onHitWall(HitWallEvent e) {
    }

    public void onRobotDeath(RobotDeathEvent e) {
    }

    public void onSkippedTurn(SkippedTurnEvent e) {
    }

    public void onWin(WinEvent e) {
    }
}

