/*
 * Decompiled with CFR 0.152.
 */
package morbid;

import java.awt.Color;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import morbid.BrokeredObject;
import morbid.EnemyAnalyzer;
import morbid.EnemyBulletManager;
import morbid.IEnemyAnalyzer;
import morbid.IEnemyBulletManager;
import morbid.IEnemySelectionStrategy;
import morbid.IEventListener;
import morbid.IMotionManager;
import morbid.IMotionStrategy;
import morbid.IPotentialManager;
import morbid.IRobotController;
import morbid.IRobotPositionManager;
import morbid.IStatsManager;
import morbid.IWeaponManager;
import morbid.IWeaponStrategy;
import morbid.MotionManager;
import morbid.PotentialManager;
import morbid.RobotPositionManager;
import morbid.Utils;
import morbid.WeaponManager;
import robocode.AdvancedRobot;
import robocode.Condition;
import robocode.Event;
import robocode.RadarTurnCompleteCondition;

class RobotController
implements IRobotController {
    private final AdvancedRobot m_robot;
    private final List m_eventQueue;
    private final Map m_eventListeners;
    private final Map m_eventListenerChannels;
    private final IMotionManager m_motionManager;
    private final IWeaponManager m_weaponManager;
    private final IRobotPositionManager m_robotPositionManager;
    private final IEnemyBulletManager m_enemyBulletManager;
    private final IEnemyAnalyzer m_enemyAnalyzer;
    private final IPotentialManager m_potentialManager;
    private final IStatsManager m_statsManager;
    private static final String CFG_RESOURCE_NAME = "morbid/MorbidClown.cfg";
    private static final String[] BROKERED_CLASSES = new String[]{"morbid.BasicRandomMotionStrategy", "morbid.BulletDodgingMotionStrategy2", "morbid.LMeleeMotionStrategy", "morbid.NearestEnemySelectionStrategy", "morbid.MeleeEnemySelectionStrategy", "morbid.SeriesPredictorWeaponStrategy"};
    private static final Map s_classCache = new HashMap();
    private final Map m_brokeredTypeGroups;
    private final Map m_activeBrokeredObjects;
    private static final Class[] CONSTRUCTOR_ARGS = new Class[]{class$morbid$IRobotController == null ? (class$morbid$IRobotController = RobotController.class$("morbid.IRobotController")) : class$morbid$IRobotController};
    private static final boolean DEBUG = false;
    static /* synthetic */ Class class$robocode$Event;
    static /* synthetic */ Class class$morbid$IRobotController;

    public void setup() {
        this.m_robot.setColors(Color.black, Color.red, Color.black);
        this.m_robot.setAdjustGunForRobotTurn(true);
        this.m_robot.setAdjustRadarForGunTurn(true);
        this.m_robot.setAdjustRadarForRobotTurn(true);
        this.m_robot.addCustomEvent((Condition)new RadarTurnCompleteCondition(this.m_robot));
    }

    public void addEventListener(IEventListener listener) {
        Class[] acceptableEventTypes;
        if (listener != null && (acceptableEventTypes = listener.getAcceptableEventTypes()) != null) {
            int e = 0;
            while (e < acceptableEventTypes.length) {
                Class eventType = acceptableEventTypes[e];
                HashSet<IEventListener> listeners = (HashSet<IEventListener>)this.m_eventListeners.get(eventType);
                if (listeners == null) {
                    listeners = new HashSet<IEventListener>();
                    this.m_eventListeners.put(eventType, listeners);
                }
                if (listeners.add(listener)) {
                    HashSet<HashSet<IEventListener>> channels = (HashSet<HashSet<IEventListener>>)this.m_eventListenerChannels.get(listener);
                    if (channels == null) {
                        channels = new HashSet<HashSet<IEventListener>>();
                        this.m_eventListenerChannels.put(listener, channels);
                    }
                    channels.add(listeners);
                }
                ++e;
            }
        }
    }

    public void removeEventListener(IEventListener listener) {
        Set channels;
        if (listener != null && (channels = (Set)this.m_eventListenerChannels.get(listener)) != null) {
            Iterator i = channels.iterator();
            while (i.hasNext()) {
                ((Set)i.next()).remove(listener);
            }
        }
    }

    public void broadcastEvent(Event event) {
        if (event != null) {
            Class<?> eventType = event.getClass();
            while (eventType != null) {
                Set listeners = (Set)this.m_eventListeners.get(eventType);
                if (listeners != null) {
                    Iterator i = listeners.iterator();
                    while (i.hasNext()) {
                        ((IEventListener)i.next()).acceptEvent(event);
                    }
                }
                if (eventType == (class$robocode$Event == null ? RobotController.class$("robocode.Event") : class$robocode$Event)) break;
                eventType = eventType.getSuperclass();
            }
        }
    }

    public void update() {
        this.m_motionManager.update();
        this.m_weaponManager.update();
        this.m_robotPositionManager.update();
        this.m_enemyAnalyzer.update();
        this.m_statsManager.update();
        this.m_enemyBulletManager.update();
        this.m_potentialManager.update();
        this.updateBrokeredObjects();
    }

    public void act() {
        this.m_motionManager.act();
        this.m_weaponManager.act();
        this.m_robotPositionManager.act();
        this.m_statsManager.act();
        this.m_eventQueue.clear();
        this.m_robot.execute();
    }

    public AdvancedRobot getRobot() {
        return this.m_robot;
    }

    public List getEventQueue() {
        return Collections.unmodifiableList(this.m_eventQueue);
    }

    public void addEvent(Event event) {
        this.m_eventQueue.add(event);
        this.broadcastEvent(event);
    }

    public IMotionStrategy getMotionStrategy() {
        return (IMotionStrategy)((Object)this.getCurrentlyActiveBrokeredObject("MOTION_STRATEGY"));
    }

    public IEnemySelectionStrategy getEnemySelectionStrategy() {
        return (IEnemySelectionStrategy)((Object)this.getCurrentlyActiveBrokeredObject("ENEMY_STRATEGY"));
    }

    public IWeaponStrategy getWeaponStrategy() {
        return (IWeaponStrategy)((Object)this.getCurrentlyActiveBrokeredObject("WEAPON_STRATEGY"));
    }

    public IMotionManager getMotionManager() {
        return this.m_motionManager;
    }

    public IWeaponManager getWeaponManager() {
        return this.m_weaponManager;
    }

    public IRobotPositionManager getRobotPositionManager() {
        return this.m_robotPositionManager;
    }

    public IEnemyBulletManager getEnemyBulletManager() {
        return this.m_enemyBulletManager;
    }

    public IEnemyAnalyzer getEnemyAnalyzer() {
        return this.m_enemyAnalyzer;
    }

    public IPotentialManager getPotentialManager() {
        return this.m_potentialManager;
    }

    public IStatsManager getStatsManager() {
        return this.m_statsManager;
    }

    public String toString() {
        return this.getClass().getName() + '@' + this.m_robot.getTime();
    }

    RobotController(AdvancedRobot robot, IStatsManager statsManager) {
        this.m_robot = robot;
        this.m_eventQueue = new ArrayList();
        this.m_eventListeners = new HashMap();
        this.m_eventListenerChannels = new HashMap();
        this.m_motionManager = new MotionManager(this);
        this.m_weaponManager = new WeaponManager(this);
        this.m_robotPositionManager = new RobotPositionManager(this);
        this.m_enemyBulletManager = new EnemyBulletManager(this);
        this.m_enemyAnalyzer = new EnemyAnalyzer(this);
        this.m_potentialManager = new PotentialManager(this);
        this.m_statsManager = statsManager;
        this.m_brokeredTypeGroups = new HashMap();
        this.m_activeBrokeredObjects = new HashMap();
        Object[] constructorParms = new Object[]{this};
        int n = 0;
        while (n < BROKERED_CLASSES.length) {
            String name = BROKERED_CLASSES[n];
            try {
                Class<?> cls = (Class<?>)s_classCache.get(name);
                if (cls == null) {
                    cls = Utils.getResourceLoader().loadClass(name);
                    s_classCache.put(name, cls);
                }
                Constructor constructor = cls.getConstructor(CONSTRUCTOR_ARGS);
                BrokeredObject object = (BrokeredObject)constructor.newInstance(constructorParms);
                object.create();
                String type = object.getType();
                ArrayList<BrokeredObject> group = (ArrayList<BrokeredObject>)this.m_brokeredTypeGroups.get(type);
                if (group == null) {
                    group = new ArrayList<BrokeredObject>();
                    this.m_brokeredTypeGroups.put(type, group);
                }
                group.add(object);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException("failed to load [" + name + "]: " + e.getTargetException());
            }
            catch (Throwable e) {
                throw new RuntimeException("failed to load [" + name + "]: " + e);
            }
            ++n;
        }
    }

    private void updateBrokeredObjects() {
        Iterator i = this.m_brokeredTypeGroups.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            List group = (List)entry.getValue();
            if (group == null) continue;
            double bestBid = Double.NEGATIVE_INFINITY;
            BrokeredObject newActive = null;
            int o = 0;
            while (o < group.size()) {
                BrokeredObject bidder = (BrokeredObject)group.get(o);
                double bid = bidder.bid();
                if (bid > bestBid) {
                    bestBid = bid;
                    newActive = bidder;
                }
                ++o;
            }
            BrokeredObject currentlyActive = (BrokeredObject)this.m_activeBrokeredObjects.get(entry.getKey());
            if (currentlyActive != null && currentlyActive == newActive) continue;
            if (currentlyActive != null) {
                currentlyActive.passivate();
            }
            newActive.activate();
            this.m_activeBrokeredObjects.put(entry.getKey(), newActive);
        }
    }

    private BrokeredObject getCurrentlyActiveBrokeredObject(String type) {
        Object result = this.m_activeBrokeredObjects.get(type);
        return (BrokeredObject)result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

