package SHAM;

import robocode.*;

import java.awt.geom.Point2D;
import java.awt.Color;


/**
 * SHAM.WOW created by Steven Hatton and Aditya Majumdar Period 3, JAVA
 * Programming Due: 06/05/09 Robocode, JAVA, Second Semester Final Project
 * 
 * Strafer bot from lesson stripped down to just the onScannedRobot and helper
 * methods. Will lock on to a robot and strafe around them. NOTE: Not get
 * closer.
 */
public class Strafer
{
    private AdvancedRobot _robot;

    private byte radarDirection = 1;

    private byte moveDirection = 1;


    public Strafer( AdvancedRobot robot )
    {
        _robot = robot;
    }


    // public void run()
    // {
    // setColors( Color.yellow, Color.cyan, Color.gray );
    // setAdjustRadarForGunTurn( true );
    // setAdjustGunForRobotTurn( true );
    //
    // while ( true )
    // {
    // doRadar();
    // doMove();
    // doGun();
    // execute();
    // }
    // }

    // public void onScannedRobot( ScannedRobotEvent e )
    // {
    // // track if we have no enemy, the one we found is significantly
    // // closer, or we scanned the one we've been tracking.
    // if ( enemy.none() || e.getDistance() < enemy.getDistance() - 70
    // || e.getName().equals( enemy.getName() ) )
    // {
    //
    // // track him using the NEW update method
    // enemy.update( e, this );
    // }
    // }

    // public void onRobotDeath( RobotDeathEvent e )
    // {
    // // see if the robot we were tracking died
    // if ( e.getName().equals( enemy.getName() ) )
    // {
    // enemy.reset();
    // }
    // }
    //
    // void doRadar()
    // {
    // if ( enemy.none() )
    // {
    // // look around if we have no enemy
    // setTurnRadarRight( 360 );
    // }
    // else
    // {
    // // oscillate the radar
    // double turn = getHeading() - getRadarHeading() + enemy.getBearing();
    // turn += 30 * radarDirection;
    // setTurnRadarRight( normalizeBearing( turn ) );
    // radarDirection *= -1;
    // }
    // }

    public void onScannedRobot( ScannedRobotEvent e )
    {
        // always square off against our enemy
        _robot.setTurnRight( normalizeBearing( e.getBearing() + 90 ) );

        // strafe by changing direction every 20 ticks
        if ( _robot.getTime() % 20 == 0 )
        {
            moveDirection *= -1;
            _robot.setAhead( 150 * moveDirection );
        }
    }


    // void doGun()
    // {
    // // don't shoot if I've got no enemy
    // if ( enemy.none() )
    // return;
    //
    // // calculate firepower based on distance
    // double firePower = Math.min( 400 / enemy.getDistance(), 3 );
    // // calculate speed of bullet
    // double bulletSpeed = 20 - firePower * 3;
    // // distance = rate * time, solved for time
    // long time = (long)( enemy.getDistance() / bulletSpeed );
    //
    // // calculate gun turn to predicted x,y location
    // double futureX = enemy.getFutureX( time );
    // double futureY = enemy.getFutureY( time );
    // double absDeg = absoluteBearing( getX(), getY(), futureX, futureY );
    //
    // // turn the gun to the predicted x,y location
    // setTurnGunRight( normalizeBearing( absDeg - getGunHeading() ) );
    //
    // // if the gun is cool and we're pointed in the right direction, shoot!
    // if ( getGunHeat() == 0 && Math.abs( getGunTurnRemaining() ) < 10 )
    // {
    // setFire( firePower );
    // }
    // }

    // computes the absolute bearing between two points
    double absoluteBearing( double x1, double y1, double x2, double y2 )
    {
        double xo = x2 - x1;
        double yo = y2 - y1;
        double hyp = Point2D.distance( x1, y1, x2, y2 );
        double arcSin = Math.toDegrees( Math.asin( xo / hyp ) );
        double bearing = 0;

        if ( xo > 0 && yo > 0 )
        { // both pos: lower-Left
            bearing = arcSin;
        }
        else if ( xo < 0 && yo > 0 )
        { // x neg, y pos: lower-right
            bearing = 360 + arcSin; // arcsin is negative here, actually 360 -
                                    // ang
        }
        else if ( xo > 0 && yo < 0 )
        { // x pos, y neg: upper-left
            bearing = 180 - arcSin;
        }
        else if ( xo < 0 && yo < 0 )
        { // both neg: upper-right
            bearing = 180 - arcSin; // arcsin is negative here, actually 180 +
                                    // ang
        }

        return bearing;
    }


    // normalizes a bearing to between +180 and -180
    double normalizeBearing( double angle )
    {
        while ( angle > 180 )
            angle -= 360;
        while ( angle < -180 )
            angle += 360;
        return angle;
    }
}
