package doka;

import robocode.*;
import robocode.util.*;
import java.awt.*;
import java.awt.geom.*;
import java.util.ArrayList; 


// API help : http://robocode.sourceforge.net/docs/robocode/robocode/Robot.html

class Wave {
	double bulletPower;
	Point2D gunLocation;
	double bearing;
	double distanceTraveled;
	int direction;
	double[] returnSegment;


	private AdvancedRobot robot;
 
	private static final double MAX_DISTANCE = 1000;
 
	Wave(AdvancedRobot _robot) {
		this.robot = _robot;
	}
 
	public void advance() {
		distanceTraveled += Rules.getBulletSpeed(bulletPower);
	}
 
	static int readings = 0;

	public boolean hasArrived(Point2D targetLocation) {
		if(distanceTraveled > gunLocation.distance(targetLocation) - 18){
			double desiredDirection = Math.atan2(targetLocation.getX() - gunLocation.getX(), targetLocation.getY() - gunLocation.getY());
			double angleOffset = Utils.normalRelativeAngle(desiredDirection - bearing);
			double escapeAngle = Math.asin(8 / Rules.getBulletSpeed(bulletPower));
			double guessFactor = Math.max(-1, Math.min(1, angleOffset / escapeAngle)) * direction;
			int index = (int) Math.round((returnSegment.length - 1) /2 * (guessFactor + 1));
			// returnSegment[index]++;
			readings++;
			returnSegment[index] = ((returnSegment[index] * (Math.min(readings, 200) - 1) + 1) / Math.min(readings, 200));
			return true;
		}
		return false;
	}
}


public class Shinigami extends AdvancedRobot
{
	// <UTILS>
	// private double limit(double a, double min, double max){
	// 	return Math.min(max, Math.max(min, a));
	// }

	private double toRad(double angle){
		return angle*Math.PI/180;
	}
	private Point2D project(Point2D sourceLocation, double angle, double length) {
		return new Point2D.Double(sourceLocation.getX() + Math.sin(angle) * length,
				sourceLocation.getY() + Math.cos(angle) * length);
	}
	
	private double absoluteBearing(Point2D source, Point2D target) {
		return Math.atan2(target.getX() - source.getX(), target.getY() - source.getY());
	}
	// </UTILS>

	public void run() {
		setAdjustGunForRobotTurn(true);
		setAdjustRadarForGunTurn(true);
		setColors(Color.black,Color.black,Color.black,Color.black,Color.black); // body,gun,radar,bullet,scanarc

		myWaves = new ArrayList<Wave>();

		turnRadarRightRadians(Double.POSITIVE_INFINITY);

		// Robot main loop
		while(true) {
			scan();
			execute();
		}
	}

	// targeting
	ArrayList<Wave> myWaves;
	// 31 is the number of unique GuessFactors we're using
	// Note: this must be odd number so we can get
	// GuessFactor 0 at middle.
	static final int BINS = 31;
	// SEGMENTS:
	// distance: onScannedRobot can scan up to 1200px, so there are 9 distance segments of 140px each
	// lateral velocity: 3 bins, 1 per 3 velocity units [0-3], [3-6], [6-9]
	// distance to wall: calculated in the direction the robot is currently moving, 1 per 50px under 100px. so 3 bins.
	// acceleration: 3 bins (positive, 0, negative)

	static double[][][][][] stats = new double[9][3][3][3][31];
	int enemyDirection = 1;
	int enemyVelocity = 0;


	// movement
	boolean stopandgo = true;
	int timesHit = 0;
	int dir = 1;

	double prevEnergy = 100.0;

	//                              0.0 0.5 1.0 1.5 2.0 2.5 3.0
	//                              0   1   2   3   4   5   6
	static int[] travelDistLookup = {19, 27, 33, 37, 48, 56, 64};

	public void onScannedRobot(ScannedRobotEvent e) {
		//radar lock
		double radarTurn = getHeadingRadians() + e.getBearingRadians() - getRadarHeadingRadians();
		setTurnRadarRightRadians(1.9 * Utils.normalRelativeAngle(radarTurn));

		// general variables
		double enemyAbsoluteBearing = getHeadingRadians() + e.getBearingRadians();
		double enemyDistance = e.getDistance();
		Point2D robotLocation = new Point2D.Double(getX(), getY());
		Point2D enemyLocation = project(robotLocation, enemyAbsoluteBearing, enemyDistance);

		
		//targeting
		double bulletPower = 2.49;
	 
		// dont use high power bullets if a smaller one will kill the enemy anyway
		bulletPower = Math.min(bulletPower, e.getEnergy()/4.0);
		// double bulletPower = Math.max(0.1,Math.random() * 3.0);
		double headOnBearing = getHeadingRadians() + e.getBearingRadians();
		
		// double linearBearing = headOnBearing + Math.asin(e.getVelocity() / Rules.getBulletSpeed(bulletPower) * Math.sin(e.getHeadingRadians() - headOnBearing));
		
		double escapeAngle = Math.asin(8 / Rules.getBulletSpeed(bulletPower));
		double randomAimOffset = -escapeAngle + Math.random() * 2 * escapeAngle;

		for (int i = 0; i < myWaves.size(); i++) {
			Wave w = (Wave)myWaves.get(i);
			w.advance();
			if(w.hasArrived(enemyLocation)){
				myWaves.remove(i);
				i--;
			}
		}

		// don't try to figure out the direction they're moving 
		// if they're not moving, just use the direction we had before
		if (e.getVelocity() != 0)
		{
			if (Math.sin(e.getHeadingRadians()-headOnBearing)*e.getVelocity() < 0)
				enemyDirection = -1;
			else
				enemyDirection = 1;
		}


		// figure out what shot to take

		// get enemy distance to wall
		Point2D enemyDestination;
		Rectangle2D fieldRectangle = new Rectangle2D.Double(16, 16, getBattleFieldWidth()-32, getBattleFieldHeight()-32);

		int wallDistBin = 2;

		double enemyHeading = e.getHeadingRadians() + ((Math.signum(e.getVelocity()) == -1) ? Math.PI : 0);
		for(int i = 0; i < 2; i++){
			enemyDestination = project(enemyLocation, enemyHeading, i*50 + 50);
			if (!fieldRectangle.contains(enemyDestination)){
				wallDistBin = i;
				break;
			}
		}

		// calc enemy lateral velocity
		double enemyLateralVelocity = e.getVelocity() * Math.sin(e.getHeadingRadians() - headOnBearing);

		// calc enemy acceleration
		int acceleration = Integer.signum((int)(e.getVelocity() - enemyVelocity));
 		enemyVelocity = (int)e.getVelocity();

 		// get the right bin
		double[] currentStats = stats[(int)(e.getDistance() / 140)][(int)Math.abs(enemyLateralVelocity/3)][wallDistBin][acceleration+1]; 

		System.out.println(enemyDistance/100);

		// TODO: maybe use random bin instead of middle one as default?
		int bestindex = 15;	// initialize it to be in the middle, guessfactor 0.
		for (int i=0; i<31; i++)
			if (currentStats[bestindex] < currentStats[i])
				bestindex = i;
 
		// this should do the opposite of the math in the wave class:
		double guessfactor = (double)(bestindex - (BINS - 1) / 2) / ((BINS - 1) / 2);
		double angleOffset = enemyDirection * guessfactor * escapeAngle;

		// if the enemy is disabled, shoot head-on
		if(e.getEnergy() <= 0){
			angleOffset = 0;
		}

		double gunAdjust = Utils.normalRelativeAngle(headOnBearing + angleOffset - getGunHeadingRadians());

		// anti bullet-shielding
		// just add a little random offset
		// we use this calculation to scale the angle to the distance of the enemy
		// the constant inside the atan is the amount of pixels we can be off in either side
		gunAdjust += (Math.random()*2-1)*Math.atan(2/enemyDistance);

		setTurnGunRightRadians(gunAdjust);

		// fire if we can and keep track of my shots (waves)
		if (getGunHeat() == 0 && gunAdjust < Math.atan(9/e.getDistance()) && setFireBullet(bulletPower) != null)
		{
			Wave wave = new Wave(this);
			wave.gunLocation = new Point2D.Double(getX(), getY());
			wave.bulletPower = bulletPower;
			wave.bearing = headOnBearing;
			wave.direction = enemyDirection;
			wave.returnSegment = currentStats;

			this.myWaves.add(wave);		
		}





		// movement

		double traveldist = 0;

		// if we're losing, change to alternative movement
		// if(getEnergy() < 50 && e.getEnergy() > getEnergy()){
		if(timesHit >= 2/* && e.getEnergy() > getEnergy()*/){
			stopandgo = false;
		}

		double dEnergy = prevEnergy-e.getEnergy();
		prevEnergy = e.getEnergy();
		if(stopandgo){
			// check if the enemy fired
			if(getDistanceRemaining() == 0.0 && dEnergy > 0 && dEnergy <= 3.0){
				// look up distance we can travel before the enemy can fire again
				traveldist = travelDistLookup[(int)(dEnergy*2)];
			}
		}else{
			traveldist = 100;
			// if(Math.random() < 0.05){
			// 	setMaxVelocity(Math.random()*8+4);
			// 	System.out.println("velocity changed");
			// }
		}

		Point2D robotDestination;

		final double MAX_TRIES = 125;
		final double DEFAULT_EVASION = 1.2;
		final double WALL_BOUNCE_TUNER = 0.699484;
		final double DIR_ANGLE = 0.4;

		// Rectangle2D fieldRectangle = new Rectangle2D.Double(18, 18, getBattleFieldWidth()-36, getBattleFieldHeight()-36);
		double tries = 0;
		do{
			robotDestination = project(enemyLocation, enemyAbsoluteBearing + Math.PI + DIR_ANGLE*dir, enemyDistance * (DEFAULT_EVASION - tries / 100.0));
			tries++;
		}
		while (!fieldRectangle.contains(robotDestination) && tries < MAX_TRIES);

		//if (/*Math.random() < (GFTUtils.bulletVelocity(enemyFirePower) / REVERSE_TUNER) / enemyDistance ||*/
		//		tries > (enemyDistance / GFTUtils.bulletVelocity(enemyFirePower) / WALL_BOUNCE_TUNER)) {
		//	direction = -direction;
		//}
		boolean changeDir = false;
		double bulletSpeed = 11;//Rules.getBulletSpeed(dEnergy);
		// don't randomly change direction when using stop&go to avoid being hit by head-on targeting
		if (!stopandgo &&  Math.random() < ( bulletSpeed / 0.421075) / enemyDistance) {
			changeDir = true;
		}
		// dir = Math.random() < .5 ? -1 : 1;
		if(tries > (enemyDistance / bulletSpeed / WALL_BOUNCE_TUNER)) {
			changeDir = true;
		}

		if(changeDir)
			dir *= -1;

		// System.out.println(tries);
		// Jamougha's cool way
		double turn = absoluteBearing(robotLocation, robotDestination) - getHeadingRadians();



		// double moveoffset = 0;
		// double dDist = e.getDistance()-300;
		// // uses a sigmoid curve to smoothly calculate and offset angle and also limit it to a maximum angle
		// double x = dDist/75;
		// moveoffset = -toRad(30)*(x/Math.sqrt(1+x*x));


		// double moveangle = getHeadingRadians() + e.getBearingRadians() - dir*(toRad(90) + moveoffset);

		// //change direction if we're gonna hit a wallotherwise
		// double stick = 150;
		// Rectangle2D fieldRect = new Rectangle2D.Double(18, 18, getBattleFieldWidth()-36, getBattleFieldHeight()-36);
		// if (!fieldRect.contains(getX()+Math.sin(moveangle)*stick, getY()+ Math.cos(moveangle)*stick))
		// {
		// 	dir *= -1;
		// 	moveangle = getHeadingRadians() + e.getBearingRadians() - dir*(toRad(90) + moveoffset);
		// 	System.out.println(".");
		// }
		// double turn = moveangle-getHeadingRadians();

		// I don't know how, but this works...
		if(traveldist != 0)
			setAhead(Math.signum(Math.cos(turn))*traveldist);
		setTurnRightRadians(Math.tan(turn));

		
	}

	//When our bullet hits them, they lose energy
	public void onBulletHit(BulletHitEvent e) {
		prevEnergy -= Rules.getBulletDamage(e.getBullet().getPower());
	}
	//When we get hit by the enemies bullet, they gain energy
	public void onHitByBullet(HitByBulletEvent e) {
		prevEnergy += Rules.getBulletHitBonus(e.getPower());
		timesHit++;
	}


	// public void onPaint(Graphics2D g) {
	// 	// Set the paint color to red
	// 	g.setColor(java.awt.Color.RED);
	// 	// Paint a filled rectangle at (50,50) at size 100x150 pixels
	// 	// g.fillRect(50, 50, 100, 150);
	// 	for (int i = 0; i < myWaves.size(); i++) {
	// 		Wave w = (Wave)myWaves.get(i);
	// 		Ellipse2D.Double circle = new Ellipse2D.Double(w.gunLocation.getX()-w.distanceTraveled, w.gunLocation.getY()-w.distanceTraveled, w.distanceTraveled*2, w.distanceTraveled*2);
	// 		g.draw(circle);
	// 	}
	// }
}
