package suh.nano;

import robocode.*;
import robocode.util.Utils;

public class CrossH extends AdvancedRobot {
    private int dir = 1;
    
    @Override
    public void run() {
	setAdjustGunForRobotTurn(true);
	setAdjustRadarForGunTurn(true);
	setAdjustRadarForRobotTurn(true);
	setTurnRadarRightRadians(Double.POSITIVE_INFINITY);
	while(true) {
	    ahead(100);
	    back(100);
	    turnRight(dir * 90);
	}
    }
    
    @Override
    public void onScannedRobot(ScannedRobotEvent e) {
	double bearing;
	
	// Radar
	setTurnRadarRightRadians(2.0 * Utils.normalRelativeAngle((bearing = getHeadingRadians() + e.getBearingRadians()) - getRadarHeadingRadians()));
	
	// Targeting
	setTurnGunRightRadians(Utils.normalRelativeAngle(bearing - getGunHeadingRadians()));
	setFire(600.0/e.getDistance());
    }
    
    @Override
    public void onHitByBullet(HitByBulletEvent e) {
	dir = -dir;
    }
}
