package nat.radar;

import java.util.LinkedHashMap;

import robocode.RobotDeathEvent;
import robocode.RobotStatus;
import robocode.ScannedRobotEvent;
import robocode.StatusEvent;

import nat.base.EventListener;
import nat.base.Logger;
import nat.base.Radar;
import nat.base.Time;
import nat.base.actors.RadarActor;
import nat.gfx.RobocodeGraphics;
import nat.utils.M;

public class MeleeRadar extends EventListener implements Radar {
	private LinkedHashMap<String, Double> enemyScanMap;
	private double scanDirection = 1;
	private String eldestRobot;
	private RobotStatus status;
	private Time time;

	public MeleeRadar(Logger logger, RobocodeGraphics g) {
		enemyScanMap = new LinkedHashMap<String, Double>(15, 2, true);
	}

	@Override
	public void doRadar(RadarActor actor) {
		actor.turnRadar(scanDirection / 0d);
	}

	@Override
	public void onScannedRobot(ScannedRobotEvent e) {
		String name = e.getName();
		enemyScanMap.put(name, status.getHeadingRadians() + e.getBearingRadians());
		
		if (time.getOthers() == enemyScanMap.size() && (eldestRobot == null || eldestRobot.equals(name))) {
			double newAngle = enemyScanMap.values().iterator().next();
			scanDirection = M.normalRelativeAngle(newAngle - status.getRadarHeadingRadians());
		}
	}

	@Override
	public void onRobotDeath(RobotDeathEvent e) {
		enemyScanMap.remove(e.getName());
	}

	@Override
	public void onStatus(StatusEvent e, Time time) {
		status = e.getStatus();
		this.time = time;
	}
}
