package kvk.Utils;
import java.awt.Color;

/**
 *  Constantes : les constantes utilises par HebusLeTroll
 *
 * @author     Ssin.le.Terrible
 * @created    10 septembre 2003
 */
public class C {

	//******************************************************************
	//                                                                 *
	//                  CONFIGURATION PAR DEFAUT                       *
	//                                                                 *
	//******************************************************************

	public static  String    CONFIGURATION_FILE       = "HebusLeTroll.cfg";        // nom du fichier de configuration
	public static  boolean   CAN_MOVE_DEFAULT         = true;                      // auttorise les movements
	public static  boolean   CAN_FIRE_DEFAULT         = true;                      // autorise les tirs
	public static  double    FIRE_POWER_MIN_DEFAULT   = 0d;                        // puissance d'un boulet mini
	public static  double    FIRE_POWER_MAX_DEFAULT   = 10d;                       // puissance d'un boulet maxi
	public static  boolean   CAN_DRAW_OPENGL_DEFAULT  = false;                     // autorise les dessins de dbugage avec RobocodeGL

	//******************************************************************
	//                                                                 *
	//                            ANGLES                               *
	//                                                                 *
	//******************************************************************

	public static  double    _PI6                     = Math.PI / 6d;              //30
	public static  double    _PI4                     = Math.PI / 4d;              //45
	public static  double    _PI3                     = Math.PI / 3d;              //60
	public static  double    _PI2                     = Math.PI / 2d;              //90
	public static  double    _3PI4                    = 3d * Math.PI / 4d;         //135
	public static  double    _PI                      = Math.PI;                   //180
	public static  double    _5PI4                    = 5d * Math.PI / 4d;         //225
	public static  double    _3PI2                    = 3d * Math.PI / 2d;         //270
	public static  double    _7PI4                    = 7d * Math.PI / 4d;         //315
	public static  double    _2PI                     = 2d * Math.PI;              //360
	public static  double    TURN_CONSTANT_1          = Math.toRadians(10d);
	public static  double    TURN_CONSTANT_2          = Math.toRadians(0.75d);

	//******************************************************************
	//                                                                 *
	//                            BOULETS                              *
	//                                                                 *
	//******************************************************************

	public static  double    MAX_BULLET_SPEED         = 20;
	public static  double    MAX_BULLET_POWER         = 3d;
	public static  double    MIN_BULLET_POWER         = 0.1;
	public static  double    BULLET_HIT_REWARD        = 3d;
	public static  double    HIT_DAMAGE               = 4d;
	public static  double    ADDITIONAL_HIT_DAMAGE    = 2d;
	public static  double    MAX_BULLET_DAMAGE        = (HIT_DAMAGE * MAX_BULLET_POWER) + (ADDITIONAL_HIT_DAMAGE * (MAX_BULLET_POWER - 1));
	public static  int       HIT_RATE_LIST_SIZE       = 50;

	//******************************************************************
	//                                                                 *
	//                             MODES                               *
	//                                                                 *
	//******************************************************************

	// Radars
	public static  int       RADAR_MODES              = 2;                         //Nombre de modes de radar
	public static  int       RADAR_FULL_ROTATION      = 0;                         //Radar en rotation continue
	public static  int       RADAR_SCAN_ALL           = 1;                         //Scan de tous les bots en jeu
	// Mouvements
	public static  int       MOVE_MODES               = 3;                         //Nombre de mouvements
	public static  int       MOVE_NIMROD_STYLE        = 0;                         //Dplacement faon Nimrod 0.55
	public static  int       MOVE_RANDOM_OvO_STYLE    = 1;                         //Dplacement alatoire pour duel
	public static  int       MOVE_TO_CENTER           = 2;                         //Dplacement en spirale vers le centre
	// Canons
	public static  int       GUN_MODES                = 3;                         //Nombre de canons
	public static  int       GUN_DIRECT_SHOOT         = 0;                         //Canon  tir direct dur la cible
	public static  int       GUN_NIMROD_STYLE         = 1;                         //Canon de cx.mini.Nimrod 0.50
	public static  int       GUN_PATTERN_MATCHER      = 2;                         //Canon  recherche de squences
	public static  String[]  GUN_NAMES                = {"Direct shoot gun", "cx.mini.Nimrod 0.50 gun", "Pattern matcher gun"};

	//******************************************************************
	//                                                                 *
	//                           DONNEES                               *
	//                                                                 *
	//******************************************************************

	public static  int       PATTERN_SIZE_MIN         = 10;                        //Taille mini de la squence
	public static  int       PATTERN_MAX_SIZE         = 3000;                      //Taille maxi de l'historique
	public static  int       PATTERN_STEP             = 2;                         //Nb de char por reprsenter un mouvement
}


