package nz.jdc.micro;

import java.awt.Color;

import robocode.AdvancedRobot;
import robocode.HitByBulletEvent;
import robocode.Rules;
import robocode.ScannedRobotEvent;
import robocode.util.Utils;
import java.awt.geom.Rectangle2D;
import java.awt.geom.Point2D;
import java.util.Arrays;

/**
 * HedgehogP 
 * Named by my wife, Yayoi, because hedgehogs are cute. Hopefully this one has some spikes.
 * My fourth bot. First micro bot.
 * 
 * Firing: Pattern matching.
 * Movement: Bullet dodge, oscillate, mirror and flat, with dynamic selection between modes.
 * 
 * Credits: 
 * Gun is a slightly modified copy of Eric Simonton's WeekendObsession.
 * Movenment is inspired by the wiki, Freddie, Waylander and many others.
 *  
 * Version 1.0: 
 *   codesize : 742
 *   
 * Version 1.1: 
 *   A test version, replaced the adaptive movement with the tuned simple version from
 *   HedgehogGF to see if it is better
 *   codesize : 652
 *   
 * Version 1.2:
 *   Reverted back to the 1.0 movement, with a few minor tweaks.  
 *   codesize : 748
 *
 * @author John Cleland 
 */
public class HedgehogP extends AdvancedRobot {
  // tunable constants
  // for movement
  private final static double MOVE_DISTANCE       = 52;
  private final static double PREFERRED_RANGE     = 400;
  private final static double CLOSE_FCT           = 800;
  private final static double PERPENDICULAR       = Math.PI / 2.0;
  private final static double WALL_STICK          = 160;
  private final static double SMOOTH_INC          = 0.07;
  private final static int    NUM_MOVE_MODES      = 10;
  private final static int    MSTAT_CHANGE_TIME   = 160;
  private final static String MOVE_MULTS          = "\u0001\u0001\u0001\u0006\u0004\u0007\u0005\u0008\u0003\u00010";
  private final static double REVERSE_CHANCE      = 0.1;
  private final static double REVERSE_DIST_ADJ    = 150;
  private final static double REVERSE_SUB         = 0.02;
  private final static double RM_MULT             = 18;
  private final static double REVERSE_ANGLE       = Math.PI / 4.0;
    
  // for gun
  private final static double FIRE_POWER_FACTOR   = 800.0;
  private final static int    MAX_MATCH_LEN       = 30;
  
  // attributes
  // for movement
  private static double       enemyEnergy;
  private static double       moveDir             = 1;
  private static int          moveMode            = 0; // 0:BDstopNgo 1:BDocsilllate 2:mirror 3+:flat
  private static double[]     moveStatsGood       = new double[NUM_MOVE_MODES]; 
  private static double[]     moveStatsBad        = new double[NUM_MOVE_MODES]; 
  private static double       enemyBulletVelocity;
  private static int          mStatCount;
  private final static Rectangle2D.Double fieldRect = new Rectangle2D.Double(18, 18, 764, 564);
  
  /**
   * Bot run method.
   */
  public void run() {
    // Yayoi says he has to be pink :)
    setBodyColor(Color.PINK);
    
    // helps targeting accuracy
    setAdjustGunForRobotTurn(true);
    
    // needed for good radar lock
    setAdjustRadarForGunTurn(true);
    
    // trim pattern to reduce skipped turns
    try { enemyHistory = enemyHistory.substring(0, 4000); } catch (Exception e) { }
    
    // start our infinite radar loop
    while (true) {
      turnRadarRightRadians(1);
    }
  }
  
  /**
   * Scan handler.
   * This is where it all happens.
   */ 
  public void onScannedRobot(ScannedRobotEvent e) {
    // register vars, should be the most commonly used
    int    ri;
    double rd;
 
    // other vars
    Point2D.Double myPos;
    int     matchPos;
    int     i;
    double  bulletPower;
    double  distance;
    double  goAngle;
    double  myHeading;
    double  offset;
    double  eLatVel;
    boolean doMove = false;
    double  sum    = 0;
    
    // update move stats
    moveStatsGood[ri = moveMode]++;
    mStatCount++;

    // bullet dodge: detect enemy firing
    // rd temporarily used for enemy energy
    if ((rd = enemyEnergy - (enemyEnergy = e.getEnergy())) < 3.01 && rd > 0.09) {
      if (ri == 1) {
        moveDir = -moveDir;
      }
      doMove = true;
      enemyBulletVelocity = Rules.getBulletSpeed(rd);
    }

    // determine bullet power
    // rd temporarily used for my energy
    bulletPower = Math.min(Math.min(FIRE_POWER_FACTOR / (distance = e.getDistance()), (rd = getEnergy()) / 16), 3.0D);

    // fire
    if (rd > Math.min(enemyEnergy, 1)) {
      setFire(bulletPower);
    }
    
    // get enemy absolute bearing
    rd = e.getBearingRadians() + (myHeading = getHeadingRadians());

    // do radar scan
    setTurnRadarRightRadians(2.0 * Utils.normalRelativeAngle(rd - getRadarHeadingRadians()));
    
    // get lat vel
    eLatVel = e.getVelocity() * Math.sin(e.getHeadingRadians() - rd);

    // wall smoothing
    offset = smooth(myPos = new Point2D.Double(getX(), getY()), rd, PERPENDICULAR - (distance - PREFERRED_RANGE) / CLOSE_FCT, moveDir, WALL_STICK);
    
    // flat movement (algorithm from Waylander)
    if((ri > 2 && (Math.random() <  REVERSE_CHANCE * MOVE_MULTS.charAt(ri) * Math.sqrt(enemyBulletVelocity / (distance + REVERSE_DIST_ADJ)) - REVERSE_SUB)) 
        || Math.abs(offset) < REVERSE_ANGLE) {
      moveDir = -moveDir;
    }

    // back as front turn to desired angle
    setTurnRightRadians(Math.tan(goAngle = rd + offset - myHeading));
    setMaxVelocity(7 + Math.random() * RM_MULT);

    // do move and direction change depending on mode
    if (ri > 0 || doMove) {
      double md = MOVE_DISTANCE;
      if (ri == 2) {
        md = eLatVel * 4;
        moveDir = -Math.signum(eLatVel);
      }
      setAhead(md * Math.signum(Math.cos(goAngle)));
    }
    
    // pattern gun from WeekendOnsession by Eric Simonton
    // add last enemy move to the pattern
    enemyHistory = String.valueOf((char) eLatVel).concat(enemyHistory);

    // search for a match
    ri = MAX_MATCH_LEN;
    while((matchPos = enemyHistory.indexOf(enemyHistory.substring(0, ri--), 
      i = (int) (distance / Rules.getBulletSpeed(bulletPower)))) < 0);

    // sum the latvel offsets
    do {
      sum += (short) enemyHistory.charAt(--matchPos);
    } while (--i > 0);
    
    // adjust for walls
    sum *= Math.sin(smooth(project(myPos, rd, distance), rd, PERPENDICULAR, 1, sum));
      
    // aim gun
    setTurnGunRightRadians(Utils.normalRelativeAngle(rd + (sum / distance) - getGunHeadingRadians()));
  }
  

  /**
   * Hit by bullet, change movement strategy.
   */
  public void onHitByBullet(HitByBulletEvent e) {
    // update move stats
    int rmm;
    moveStatsBad[rmm = moveMode] += e.getPower();
    
    // if count expired, check if there is a better move mode
    if (mStatCount > MSTAT_CHANGE_TIME) {
      mStatCount = 0;
      
      for (int i = 0; i < NUM_MOVE_MODES; i++) {
        if ((moveStatsBad[i] / moveStatsGood[i]) < (moveStatsBad[rmm] / moveStatsGood[rmm])) {
          moveMode = i;
        }
      }
    }
  }

  /**
   * do wall smoothing 
   */
  private static double smooth(Point2D.Double pos, double baseAngle, double offset, double moveDir, double disatnce) {
    int i = 15;
    while(!fieldRect.contains(project(pos, baseAngle + moveDir * (offset -= SMOOTH_INC), disatnce)) && --i > 0);
    return moveDir * offset;
  }
    
  /**
   * project a location 
   */
  private static Point2D.Double project(Point2D.Double sourceLocation, double angle, double length) {
    return new Point2D.Double(sourceLocation.x + Math.sin(angle) * length,
        sourceLocation.y + Math.cos(angle) * length);
  }


  // the pattern
  public static String enemyHistory = ""
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 1
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 2
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char)-1
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char) 0 + (char) 0 + (char) 0
    + (char) 0 + (char)-2 + (char)-4 + (char)-6
    + (char)-8 + (char)-8 + (char)-8 + (char)-8
    + (char)-8 + (char)-8 + (char)-8 + (char)-8
    + (char)-8 + (char)-8 + (char)-8 + (char)-8
    + (char)-8 + (char)-8 + (char)-8 + (char)-8
    + (char)-8 + (char)-8 + (char)-8 + (char)-8
    + (char)-8 + (char)-8 + (char)-8 + (char)-8
    + (char)-8 + (char)-8 + (char)-8 + (char)-8
    + (char)-8 + (char)-8 + (char)-8 + (char)-8
    + (char)-8 + (char)-8 + (char)-8 + (char)-8
    + (char)-8 + (char)-8 + (char)-8 + (char)-8
    + (char)-7 + (char)-6 + (char)-5 + (char)-4
    + (char)-3 + (char)-2 + (char)-1 + (char) 0
    + (char) 2 + (char) 4 + (char) 6 + (char) 8
    + (char) 8 + (char) 8 + (char) 8 + (char) 8
    + (char) 8 + (char) 8 + (char) 8 + (char) 8
    + (char) 8 + (char) 8 + (char) 8 + (char) 8
    + (char) 8 + (char) 8 + (char) 8 + (char) 8
    + (char) 8 + (char) 8 + (char) 8 + (char) 8
    + (char) 8 + (char) 8 + (char) 8 + (char) 8
    + (char) 8 + (char) 8 + (char) 8 + (char) 8
    + (char) 8 + (char) 8 + (char) 8 + (char) 8
    + (char) 8 + (char) 8 + (char) 8 + (char) 8
    + (char) 8 + (char) 8 + (char) 8 + (char) 8
    + (char) 7 + (char) 6 + (char) 5 + (char) 4
    + (char) 3 + (char) 2 + (char) 1 + (char) 0;

  
  // static init
  static {
    // init move statistics
    Arrays.fill(moveStatsBad, 1);
    Arrays.fill(moveStatsGood, 50);
  }
}
