package paulk;
import robocode.*;
import robocode.util.*;
import java.util.*;
import java.awt.geom.*;

public class CanonManager {
	PaulV3 bot;
	Map lastScanned;
	Map scannedEvents;
	ArrayList strategies;
	ArrayList ondes;
	int indexB=-1;

	CanonManager(PaulV3 r){
		bot=r;
		lastScanned=new Hashtable();
		scannedEvents=new Hashtable();
		ondes=new ArrayList();
		strategies=new ArrayList();
		LT lt=new LT(scannedEvents,lastScanned,r);
		CT ct=new CT(scannedEvents,lastScanned,r);
		AT at=new AT(scannedEvents,lastScanned,r);
		HOT hot=new HOT(scannedEvents,lastScanned,r);
		GF gf=new GF(scannedEvents,lastScanned,r);
		strategies.add(0,at);
		strategies.add(0,ct);
		strategies.add(0,lt);
		strategies.add(0,hot);
		strategies.add(0,gf);
		// ordre : gf,hot,lt,ct,at
	}

	void nouvBot(PaulV3 r){
		bot=r;
		for (int i=0;i<strategies.size();i++)
			((Targeting)strategies.get(i)).nouvBot(r);
		ondes.clear();
		lastScanned.clear();
		scannedEvents.clear();
	}

	void onScannedRobot(ScannedRobotEvent e){
		String nom=e.getName();
		ScannedRobotEvent eLast=null;
		if (lastScanned.containsKey(nom))
			eLast=(ScannedRobotEvent)lastScanned.get(nom);
		lastScanned.put(nom,e);
		if (scannedEvents.containsKey(nom)){
			ArrayList l=(ArrayList)scannedEvents.get(nom);
			l.add(0,e);
		}
		else {
			ArrayList l=new ArrayList();
			scannedEvents.put(nom,l);
		}
		double absolue=e.getBearingRadians()+bot.getHeadingRadians();
		double x=bot.getX(),y=bot.getY(),d=e.getDistance();
		Point2D.Double arrivee=new Point2D.Double(x+d*Math.sin(absolue),y+d*Math.cos(absolue));
		for (int index=0;index<ondes.size();index++){
			MonOnde onde=(MonOnde)ondes.get(index);
			if (onde.passe(arrivee) && onde.getCible()==nom){
				ArrayList angles=onde.getAngles();
				Point2D.Double depart=new Point2D.Double(onde.getX(),onde.getY());
				Point2D.Double ancPos=onde.getAncPos();
				for (int curTargeting=0;curTargeting<strategies.size();curTargeting++){
					Targeting t=(Targeting)strategies.get(curTargeting);
					double angle=(Double)angles.get(curTargeting);
					t.ameliore(angle,onde,arrivee,nom);
				}
				ondes.remove(index);
				index--;
			}
		}
		if (eLast==null) return;
		Point2D.Double posBot=new Point2D.Double(bot.getX(),bot.getY());
		int segment=GF.getSegment(e,bot,eLast);
		double puissance=bot.puissance(e.getDistance());
		ArrayList angles=new ArrayList();
		for (int index=0;index<strategies.size();index++){
			Targeting t=(Targeting)strategies.get(index);
			double angle=t.angle(nom);
			angles.add(angles.size(),angle);
		}
		ondes.add(0,new MonOnde(posBot,puissance,bot,angles,nom,arrivee,segment,false));
	}

	double getFuturePos(String nom){
		double maxProba=-1,bonAngle=0;
		for (int index=0;index<strategies.size();index++){
			Targeting t=(Targeting)strategies.get(index);
			double angle=t.angle(nom),proba=t.getProba(nom);
			if (proba>=maxProba){
				maxProba=proba;
				bonAngle=angle;
				indexB=index;
			}
		}
		return bonAngle*180/Math.PI;
	}

	void feu(String nom,double puissance){
		List events=(ArrayList)scannedEvents.get(nom);
		if (events.size()<2) return;
		if (bot.setFireBullet(puissance)==null)
			return ;
		ArrayList angles=new ArrayList();
		for (int index=0;index<strategies.size();index++){
			Targeting t=(Targeting)strategies.get(index);
			double angle=t.angle(nom);
			angles.add(angles.size(),angle);
		}
//		System.out.println(nom+" "+indexB);
		ScannedRobotEvent e=(ScannedRobotEvent)lastScanned.get(nom);
		double x=bot.getX(),y=bot.getY(),d=e.getDistance();
		double angle=e.getBearingRadians()+bot.getHeadingRadians();
		Point2D.Double pos=new Point2D.Double(x+d*Math.sin(angle),y+d*Math.cos(angle));
		Point2D.Double posBot=new Point2D.Double(bot.getX(),bot.getY());
		ScannedRobotEvent eLast=(ScannedRobotEvent)events.get(1);
		int segment=GF.getSegment(e,bot,eLast);
		ondes.add(0,new MonOnde(posBot,puissance,bot,angles,nom,pos,segment,true));
	}

	public void onPaint(java.awt.Graphics2D g) {
		g.setColor(java.awt.Color.green);
		for(int i = 0; i < ondes.size(); i++){
			MonOnde onde=(MonOnde)ondes.get(i);
			if (onde.estVraie()){
				onde.affiche(g,bot.getTime());
			}
		}
		for(int i = 0; i < strategies.size(); i++){
			Targeting t=(Targeting)strategies.get(i);
			t.onPaint(g);
		}
	}
}
